% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{stats.default}
\alias{stats.default}
\title{Compute some basic descriptive statistics.}
\usage{
stats.default(x, useNA = NULL)
}
\arguments{
\item{x}{A vector or numeric, factor, character or logical values.}

\item{useNA}{For categorical \code{x}, should missing values be treated as a category?}
}
\value{
A list. For numeric \code{x}, the list contains the numeric elements:
\itemize{
  \item \code{N}: the number of non-missing values
  \item \code{NMISS}: the number of missing values
  \item \code{MEAN}: the mean of the non-missing values
  \item \code{SD}: the standard deviation of the non-missing values
  \item \code{MIN}: the minimum of the non-missing values
  \item \code{MEDIAN}: the median of the non-missing values
  \item \code{MAX}: the maximum of the non-missing values
  \item \code{Q25}: the lower quartile of the non-missing values
  \item \code{Q75}: the upper quartile of the non-missing values
  \item \code{IQR}: the inter-quartile range of the non-missing values
  \item \code{CV}: the percent coefficient of variation of the non-missing values
  \item \code{GMEAN}: the geometric mean of the non-missing values if non-negative, or \code{NA}
  \item \code{GCV}: the percent geometric coefficient of variation of the non-missing values if non-negative, or \code{NA}
}
If \code{x} is categorical (i.e. factor, character or logical), the list
contains a sublist for each category, where each sublist contains the
numeric elements:
\itemize{
  \item \code{FREQ}: the frequency count
  \item \code{PCT}: the percent relative frequency
}
}
\description{
Values of type \code{factor}, \code{character} and \code{logical} are
treated as categorical. For logicals, the two categories are given the
labels `Yes` for \code{TRUE}, and `No` for \code{FALSE}.  Factor levels with
zero counts are retained.
}
\examples{
x <- exp(rnorm(100, 1, 1))
stats.default(x)

y <- factor(sample(0:1, 99, replace=TRUE), labels=c("Female", "Male"))
y[1:10] <- NA
stats.default(y)
stats.default(is.na(y))

}
\keyword{utilities}
