% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ggplot.R
\name{as_ggplot}
\alias{as_ggplot}
\title{Storing grid.arrange() arrangeGrob() and plots}
\usage{
as_ggplot(x)
}
\arguments{
\item{x}{an object of class gtable or grob as returned by the functions
\code{\link[gridExtra:arrangeGrob]{arrangeGrob}()} and
\code{\link[gridExtra:arrangeGrob]{grid.arrange}()}.}
}
\value{
an object of class ggplot.
}
\description{
Transform the output of
 \code{\link[gridExtra:arrangeGrob]{arrangeGrob}()} and
 \code{\link[gridExtra:arrangeGrob]{grid.arrange}()} to a an object of class
 ggplot.
}
\examples{
# Creat some plots
bxp <- ggboxplot(iris, x = "Species", y = "Sepal.Length")
vp <- ggviolin(iris, x = "Species", y = "Sepal.Length",
              add = "mean_sd")

# Arrange the plots in one page
# Returns a gtable (grob) object
library(gridExtra)
gt <- arrangeGrob(bxp, vp, ncol = 2)

# Transform to a ggplot and print
as_ggplot(gt)

}
