% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_share.R
\name{facet_share}
\alias{facet_share}
\title{A shared axis for two panels}
\usage{
facet_share(facets, scales = "fixed", reverse_num = FALSE, shrink = TRUE,
  labeller = "label_value", as.table = TRUE, switch = NULL, drop = TRUE,
  dir = "h", strip.position = "top")
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[=vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, `~a
\itemize{
\item b\code{, or a character vector,}c("a", "b")`.
}}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{reverse_num}{Used when passing on flipped data (times -1) for the 
second (right/bottom) panel. If `TRUE`, this will multiply the axis labels for that panel by -1.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with formulae of the type \code{~cyl + am}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[=labeller]{labeller()}}. See
\code{\link[=label_value]{label_value()}} for more details and pointers to other
options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{dir}{Direction: either \code{"h"} for horizontal, the default, or \code{"v"},
for vertical.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}
}
\description{
`facet_share` uses [facet_wrap()] to build two panels with a shared axis.
}
\examples{
df <- data.frame(age = sample(1:20, 1000, replace = TRUE), 
                 gender = c("M","F"), levels = c("M", "F"))

# Get the count per age and sex
df$count <- 1
df <- aggregate(count ~ gender + age, data = df, length)

# For the horizontally shared axis, if we want to mirror the axes,
# we have to multiply the first panel by -1, and use coord_flip().
df_h <- df 
df_h$count = ifelse(df_h$gender == "F", df_h$count * -1, df_h$count)

p <- ggplot(df_h, aes(x = factor(age), y = count, fill = gender)) + 
  geom_bar(stat = "identity") +
  facet_share(~gender, dir = "h", scales = "free", reverse_num = TRUE) + 
  coord_flip() +
  labs(x = "Age", y = "Count") + 
  theme(legend.position = "bottom")

p

# When setting direction to vertical, and if we want to mirror the second panel,
# we must multiply the second factor by -1.
# And levels(factor(gender))[2] is M. 
df_v <- df
df_v$count <- ifelse(df_v$gender == "M", df_v$count * -1, df_v$count) 

p <- ggplot(df_v, aes(x = as.factor(age), y = count, fill = gender)) + 
  geom_bar(stat = "identity") +   
  facet_share(~gender, dir = "v", reverse_num = TRUE, 
              scales = "free", strip.position = "left") +
  labs(x = "Age", y = "Count") + 
  theme(legend.position = "left")
p
}
