% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-continuous-logFC.r
\name{FC_format}
\alias{FC_format}
\alias{FC_plain}
\title{Formatter for fold change tick labels}
\usage{
FC_format(log.base.data = 2, log.base.labels = 10, digits = 3, ...)

FC_plain(
  x,
  log.base.data = 2,
  log.base.labels = 10,
  digits = 3,
  fmt = "\%+.*g",
  ...
)
}
\arguments{
\item{log.base.data}{of data.}

\item{log.base.labels}{of labels.}

\item{digits}{number of significant digits to show.}

\item{...}{other arguments passed on to \code{\link{format}}.}

\item{x}{a numeric vector to format.}

\item{fmt}{character string containing the format for one number using
\code{*} for the precision.}
}
\value{
a function with single parameter x, a numeric vector, that
  returns a character vector.
}
\description{
Generate tick labels discounting a log transformation in data, and
optionally applying a different log transformation or no transformation.
}
\examples{

FC_format(2, 10)(1:5)
FC_format(0, 2)(c(1/4, 1/2, 1,2,4,8))
FC_format(10, 0)(-1:3)
FC_format(0, 10)(c(0.1, 1, 10, 100, 100))

}
\seealso{
Other Functions for quadrant and volcano plots: 
\code{\link{outcome2factor}()},
\code{\link{scale_colour_outcome}()},
\code{\link{scale_shape_outcome}()},
\code{\link{scale_y_Pvalue}()},
\code{\link{xy_outcomes2factor}()}
}
\concept{Functions for quadrant and volcano plots}
\keyword{internal}
