% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-tidy-eval.R
\name{tidyeval}
\alias{tidyeval}
\alias{quo}
\alias{quos}
\alias{enquo}
\alias{enquos}
\alias{quo_name}
\alias{sym}
\alias{ensym}
\alias{syms}
\alias{ensyms}
\alias{expr}
\alias{exprs}
\alias{enexpr}
\alias{enexprs}
\alias{.data}
\title{Tidy eval helpers}
\description{
\itemize{
\item \code{\link[rlang]{sym}()} creates a symbol from a string and
\code{\link[rlang:sym]{syms}()} creates a list of symbols from a
character vector.
\item \code{\link[rlang:nse-defuse]{enquo}()} and
\code{\link[rlang:nse-defuse]{enquos}()} delay the execution of one or
several function arguments. \code{enquo()} returns a single quoted
expression, which is like a blueprint for the delayed computation.
\code{enquos()} returns a list of such quoted expressions.
\item \code{\link[rlang:nse-defuse]{expr}()} quotes a new expression \emph{locally}. It
is mostly useful to build new expressions around arguments
captured with \code{\link[=enquo]{enquo()}} or \code{\link[=enquos]{enquos()}}:
\code{expr(mean(!!enquo(arg), na.rm = TRUE))}.
}

To learn more about tidy eval and how to use these tools, visit
\url{https://tidyeval.tidyverse.org} and the
\href{https://adv-r.hadley.nz/metaprogramming.html}{Metaprogramming
section} of \href{https://adv-r.hadley.nz}{Advanced R}.
}
\keyword{internal}
