% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-grey.r, R/zxx.r
\name{scale_colour_grey}
\alias{scale_color_grey}
\alias{scale_colour_grey}
\alias{scale_fill_grey}
\title{Sequential grey colour scales}
\usage{
scale_colour_grey(..., start = 0.2, end = 0.8, na.value = "red")

scale_fill_grey(..., start = 0.2, end = 0.8, na.value = "red")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{discrete_scale}}
to control name, limits, breaks, labels and so forth.}

\item{start}{gray value at low end of palette}

\item{end}{gray value at high end of palette}

\item{na.value}{Colour to use for missing values}
}
\description{
Based on \code{\link{gray.colors}}. This is black and white equivalent
of \code{\link{scale_colour_gradient}}.
}
\examples{
p <- ggplot(mtcars, aes(mpg, wt)) + geom_point(aes(colour = factor(cyl)))
p + scale_colour_grey()
p + scale_colour_grey(end = 0)

# You may want to turn off the pale grey background with this scale
p + scale_colour_grey() + theme_bw()

# Colour of missing values is controlled with na.value:
miss <- factor(sample(c(NA, 1:5), nrow(mtcars), replace = TRUE))
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(colour = miss)) +
  scale_colour_grey()
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(colour = miss)) +
  scale_colour_grey(na.value = "green")
}
\seealso{
Other colour scales: \code{\link{scale_alpha}},
  \code{\link{scale_colour_brewer}},
  \code{\link{scale_colour_gradient}},
  \code{\link{scale_colour_hue}}
}

