% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone_facet.R
\name{cloneFacet}
\alias{cloneFacet}
\title{Clone ggplot facet object}
\usage{
cloneFacet(obj, verbose = FALSE)
}
\arguments{
\item{obj}{gg facet wrap or facet_grid object}

\item{verbose}{boolean, toggles to return object or script (TRUE), Default: FALSE}
}
\value{
gg object or script
}
\description{
Clone ggplot facet object and return either a gg object or
 the script to parse and evaluate
}
\examples{
 obj <- ggplot2::facet_grid(
            rows = vars("a", "b"), cols = vars("c", "d"),
            scales = 'free', as.table = FALSE, switch = 'x', shrink = FALSE
        )

 cloneFacet(obj)
 cloneFacet(obj, verbose = TRUE)
}
