% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_plotting.R
\name{plot_prior}
\alias{plot_prior}
\title{Plot Prior Probability Density}
\usage{
plot_prior(i, p.prior, xlim = NA, natural = TRUE, n.point = 100,
  trans = NA, main = "", save.dat = FALSE, ...)
}
\arguments{
\item{i}{a numeral or name index indicating which parameter to plot}

\item{p.prior}{a prior parameter list, created usually by prior.p.dmc}

\item{xlim}{set the range of on x axis. This is usually the range for each
EAM parameter. Default is NA, letting plot facilitate to determine the range
automatically.}

\item{natural}{default TRUE}

\item{n.point}{default to plot 1e2}

\item{trans}{default NA. trans can be a scalar or vector.}

\item{main}{No function. A legency argument for compartibility reason}

\item{save.dat}{whether to save a data frame for re-plotting}

\item{...}{other arguments}
}
\description{
Plot the i'th member of list created by \code{prior.p.dmc}.  If
\code{trans=TRUE} then plot on natural (logarithmic) scale using transform
specified in \code{attr(p.prior[[i]],"trans")}. This is akin to DMC's
\code{plot.prior} but uses \code{ggplot2}. Use \code{plot.priors} to plot all
parameters at once.
}
\details{
\code{plot.prior} checks if  any of the elements in trans is \code{NA}. If
\code{trans} contains NAs, then it checks if \code{natural} is set
\code{TRUE} (by default it's \code{TRUE}). If \code{natural} is set also
\code{TRUE} (i.e., the user wants to do transformation), then checks what has
been set in the "untrans" attribute for the plotted parameter (where the i
argument indicates). Otherwise, we set it abitrarily as \code{identity}
(i.e., stay the same).
}
\examples{
pop.prior <- prior.p.dmc(
             dists = rep("tnorm", 7),
             p1=c(a=2,  v.f1=4, v.f2=3, z=0.5,sv=1, sz=0.3, t0=0.3),
             p2=c(a=0.5,v.f1=.5,v.f2=.5,z=0.1,sv=.3,sz=0.1,t0=0.05),
             lower=c(0,-5, -5, 0, 0, 0, 0),
             upper=c(5, 7,  7, 1, 2, 1, 1))
plot_prior("a", p.prior=pop.prior)
plot_prior(2,  p.prior=pop.prior)
}
\keyword{plot_prior}

