% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-heatmap-.R
\name{heatmap_layout}
\alias{heatmap_layout}
\alias{ggheatmap}
\title{Create a heatmap}
\usage{
heatmap_layout(
  data = NULL,
  mapping = aes(),
  ...,
  width = NA,
  height = NA,
  filling = waiver(),
  theme = NULL,
  active = NULL
)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout. By default, it will try to inherit from
parent layout. \code{\link[=fortify_matrix]{fortify_matrix()}} will be used to convert data to a
matrix.}

\item{mapping}{Default list of aesthetic mappings to use for main plot in the
layout. If not specified, must be supplied in each layer added to the main
plot.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}

\item{filling}{A single string of \code{"raster"} or \code{"tile"} to
indicate the filling style. By default, \code{waiver()} is used, which means that
if the input matrix has more than 20,000 cells (\code{nrow * ncol > 20000}),
\code{\link[ggplot2:geom_tile]{geom_raster()}} will be used for performance
efficiency; for smaller matrices, \code{\link[ggplot2:geom_tile]{geom_tile()}} will be
used. To customize the filling style, set this to \code{NULL}.

For backward compatibility, a single boolean value is acceptable: \code{TRUE}
means \code{waiver()}, and \code{FALSE} means \code{NULL}.

By default, the classic heatmap color scheme
\code{\link[ggplot2:scale_gradient]{scale_fill_gradient2(low = "blue", high = "red")}}
is utilized for continuous values.

You can use the options
\code{"ggalign.heatmap_continuous_fill"} or
\code{"ggalign.heatmap_discrete_fill"} to modify the
default heatmap body filling color scale. See
\code{\link[ggplot2:scale_colour_continuous]{scale_fill_continuous()}} or
\code{\link[ggplot2:scale_colour_discrete]{scale_fill_discrete()}} for details on
option settings.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout, including \code{guides}, \code{title}, \code{subtitle}, \code{caption},
\code{margins}, \code{panel.border}, and \code{background}. By default, the theme will
inherit from the parent \code{layout}. It also controls the panel spacing for all
plots in the layout.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\value{
A \code{HeatmapLayout} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{heatmap_layout} is a specialized version of \code{\link[=quad_discrete]{quad_discrete()}}, which
simplifies the creation of heatmap plots by integrating essential elements
for a standard heatmap layout, ensuring that the appropriate data mapping and
visualization layers are automatically applied. \code{ggheatmap} is an alias for
\code{heatmap_layout}.
}
\section{ggplot2 specification}{

The data input will be converted to a matrix using \code{\link[=fortify_matrix]{fortify_matrix()}}, and
the data in the underlying main plot will contain the following columns:
\itemize{
\item \code{.panel_x} and \code{.panel_y}: the column and row panel groups.
\item \code{.x} and \code{.y}: an integer index of \code{x} and \code{y} coordinates
\item \code{.discrete_x} and \code{.discrete_y}: a factor of the data labels (only
applicable when \code{.row_names} and \code{.column_names} exists).
\item \code{.row_names} and \code{.column_names}: A character of the row and column names
of the original matrix (only applicable when names exist).
\item \code{.row_index} and \code{.column_index}: the row and column index of the original
matrix.
\item \code{value}: the actual matrix value.
}
}

\examples{
ggheatmap(1:10)
ggheatmap(letters)
ggheatmap(matrix(rnorm(81), nrow = 9L))
}
