% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-gg.R
\name{align_gg}
\alias{align_gg}
\alias{ggalign}
\title{Create ggplot object with a customized data}
\usage{
align_gg(
  data = NULL,
  mapping = aes(),
  size = NULL,
  free_labs = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL
)

ggalign(
  data = NULL,
  mapping = aes(),
  size = NULL,
  free_labs = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL
)
}
\arguments{
\item{data}{A matrix, a data frame, or even a simple vector that will be
converted into a one-column matrix. If the \code{data} argument is set to \code{NULL},
the \verb{align_*} will use the \code{layout} data. Additionally, the \code{data} argument
can also accept a function (purrr-like lambda is also okay), which will be
applied with the \code{layout} data,

It is important to note that all \verb{align_*} functions consider the \code{rows} as
the observations. It means the \code{NROW(data)} must return the same number with
the parallel \code{layout} axis.
\itemize{
\item \code{layout_heatmap}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{layout_stack}: the \code{layout} data will be used as it is since we place all
plots along a single axis.
}}

\item{mapping}{Additional default list of aesthetic mappings to use for plot.}

\item{size}{Plot size, can be an \link[grid:unit]{unit} object.}

\item{free_labs}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates which axis title should be free from
alignment. If \code{NULL}, all axis title will be aligned. Default: "tlbr".}

\item{free_spaces}{A character specifies the ggplot elements which won't
count space sizes when alignment. If \code{NULL} (default), no space will be
removed. See \code{\link[=free_space]{free_space()}} for allowed values.}

\item{plot_data}{A function used to transform the plot data before rendering.
By default, it'll inherit from the parent layout. If no parent layout, the
default is to not modify the data. Use \code{NULL}, if you don't want to modify
anything.

Used to modify the data after layout has been created, but before the data is
handled of to the ggplot2 for rendering. Use this hook if the you needs
change the default data for all \code{geoms}.}

\item{limits}{A boolean value indicates whether to set the layout limtis for
the plot.}

\item{facet}{A boolean value indicates whether to set the layout facet for
the plot. If this is \code{FALSE}, \code{limits} will always be \code{FALSE} too.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the layout order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A \code{AlignGG} object.
}
\description{
\code{ggalign} is just an alias of \code{align_gg}.
}
\section{ggplot2 specification}{

\code{align_gg} initializes a \code{ggplot} data and \code{mapping}.

The internal will always use a default mapping of \code{aes(y = .data$.y)} or
\code{aes(x = .data$.x)}.

For ggplot usage, matrix (including a simple vector) data is converted into a
long-format data frame. The data in the underlying \code{ggplot} object will
contain following columns:
\itemize{
\item \code{.panel}: the panel for current layout axis.
\item \code{.x} or \code{.y}: the \code{x} or \code{y} coordinates
\item \code{.row_names} and \code{.row_index}: A factor of the row names and an integer of
row index of the original matrix or data frame.
\item \code{.column_names} and \code{.column_index}: the column names and column index of
the original matrix (only applicable if \code{data} is a \code{matrix}).
\item \code{value}: the actual matrix value  (only applicable if \code{data} is a
\code{matrix}).
}

In the case where the input data is already a data frame, three additional
columns (\code{.row_names}, \code{.row_index}, and \code{.panel}) are added to the data
frame.

if data is inherit from the \link[=ggheatmap]{heatmap} layout, an additional column
will be added.
\itemize{
\item \code{.extra_panel}: the panel information for column (left or right
annotation) or row (top or bottom annotation).
}
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    ggalign() +
    geom_point(aes(y = value))
}
