% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{pBar_LCL}
\alias{pBar_LCL}
\title{Lower Control Limit: Binomial Data (p-chart)}
\usage{
pBar_LCL(y, n, na.rm = FALSE, ...)
}
\arguments{
\item{y}{Vector of binomial proportion data (not counts). Observations
may have a different area of opportunity, n.}

\item{n}{A vector representing the area of opportunity.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector; point-wise 3-sigma lower control limit (LCL)
}
\description{
Calculates point-wise lower control limit (LCL)
for binomial proportion data acquired over a variable area of
opportunity.
}
\examples{
set.seed(5555)
p <- rbinom(n = 100, size = 30, prob = .2)
n <- rpois(100, 100)
pBar_LCL(y = p/n, n = n)

}
