% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_cmd.R
\name{map_cmd}
\alias{map_cmd}
\title{Return map elements for basemap}
\usage{
map_cmd(command, alternative = FALSE)
}
\arguments{
\item{command}{basemap layer to be added}

\item{alternative}{logical to return alternative formmatting in certain cases. Used to reduce \code{if}-\code{else} statements in \code{\link{basemap}}.}
}
\value{
A character string containing a ggplot2 plotting command. Use \code{eval(parse(text=...))} to plot the string.
}
\description{
An internal function to make \code{\link{basemap}} code more readable
}
\details{
This is an internal function, which is automatically run by the \code{\link{basemap}} function. Common users do not need to worry about these details. Basemap elements can added together using this function, \code{\link[base]{parse}} and \code{\link[base]{eval}}.
}
\examples{
## An example for utm map without glaciers or bathymetry
\dontrun{eval(parse(text=paste(map_cmd("base"), map_cmd("land_utm"),
map_cmd("grid_utm"), map_cmd("defs_utm"), sep = "+")))}
}
\seealso{
\code{\link{basemap}}
}
\author{
Mikko Vihtakari
}
\keyword{internal}
