% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMB_Stabsel.R
\name{CMB.Stabsel}
\alias{CMB.Stabsel}
\title{Loss-adapted Stability Selection}
\usage{
CMB.Stabsel(
  Dtrain,
  nsing,
  Bsing = 1,
  B = 100,
  alpha = 1,
  singfam = Gaussian(),
  evalfam = Gaussian(),
  sing = FALSE,
  M = 10,
  m_iter = 100,
  kap = 0.1,
  LS = FALSE,
  best = 1,
  wagg,
  gridtype,
  grid,
  Dvalid,
  ncmb,
  robagg = FALSE,
  lower = 0,
  singcoef = FALSE,
  Mfinal,
  ...
)
}
\arguments{
\item{Dtrain}{Data matrix. Has to be an \eqn{n \times (p+1)-}dimensional data frame in the format \eqn{(X,Y)}. The \eqn{X-}part must not
contain an intercept column containing only ones since this column will be added automatically.}

\item{nsing}{Number of observations (rows) used for the SingBoost submodels.}

\item{Bsing}{Number of subsamples based on which the SingBoost models are validated. Default is 1. Not to confuse with parameter \code{B} for the Stability Selection.}

\item{B}{Number of subsamples based on which the CMB models are validated. Default is 100. Not to confuse with \code{Bsing} for CMB.}

\item{alpha}{Optional real number in \eqn{]0,1]}. Defines the fraction of best SingBoost models used in the aggregation step. Default is 1 (use all models).}

\item{singfam}{A SingBoost family. The SingBoost models are trained based on the corresponding loss function. Default is \code{Gaussian()} (squared loss).}

\item{evalfam}{A SingBoost family. The SingBoost models are validated according to the corresponding loss function. Default is \code{Gaussian()} (squared loss).}

\item{sing}{If \code{sing=FALSE} and the \code{singfam} family is a standard Boosting family that is contained in the package
\code{mboost}, the CMB aggregation procedure is executed for the corresponding standard Boosting models.}

\item{M}{An integer between 2 and \code{m_iter}. Indicates that in every \eqn{M-}th iteration, a singular iteration will be
performed. Default is 10.}

\item{m_iter}{Number of SingBoost iterations. Default is 100.}

\item{kap}{Learning rate (step size). Must be a real number in \eqn{]0,1]}. Default is 0.1 It is recommended to use
a value smaller than 0.5.}

\item{LS}{If a \code{singfamily} object that is already provided by \code{mboost} is used, the respective Boosting algorithm
will be performed in the singular iterations if \code{Ls} is set to \code{TRUE}. Default is \code{FALSE}.}

\item{best}{Needed in the case of localized ranking. The parameter \code{K} of the localized ranking loss will be
computed by \eqn{best \cdot n} (rounded to the next larger integer). Warning: If a parameter \code{K} is inserted into the
\code{LocRank} family, it will be ignored when executing SingBoost.}

\item{wagg}{Type of row weight aggregation. \code{'weights1'} indicates that the selection frequencies of the (best)
SingBoost models are averaged. \code{'weights2'} respects the validation losses for each model and downweights the ones
with higher validation losses.}

\item{gridtype}{Choose between \code{'pigrid'} and \code{'qgrid'}.}

\item{grid}{The grid for the thresholds (in \eqn{]0,1]}) or the numbers of final variables (positive integers).}

\item{Dvalid}{Validation data for selecting the optimal element of the grid and with it the best corresponding model.}

\item{ncmb}{Number of samples used for \code{CMB}. Integer that must be smaller than the number of samples in \code{Dtrain} and higher than \code{nsing}.}

\item{robagg}{Optional. If setting \code{robagg=TRUE}, the best SingBoost models are ignored when executing the
aggregation to avoid inlier effects. Only reasonable in combination with \code{lower}.}

\item{lower}{Optional argument. Only reasonable when setting \code{robagg=TRUE}. \code{lower} is a real number in \eqn{[0,1[} (a rather
small number is recommended) and indicates that the aggregation ignores the SingBoost models with the best
performances to avoid possible inlier effects.}

\item{singcoef}{Default is \code{FALSE}. Then the coefficients for the candidate stable models are computed by standard
linear regression (provided that the number of columns is smaller than the number of samples in the training set
 for each grid element). If set to \code{TRUE}, the coefficients are computed by SingBoost.}

\item{Mfinal}{Optional. Necessary if \code{singcoef=TRUE} to determine the frequency of singular iterations in the
SingBoost models.}

\item{...}{Optional further arguments}
}
\value{
\item{colind.opt}{The column numbers of the variables that form the best stable model as a vector.}
\item{coeff.opt}{The coefficients corresponding to the optimal stable model as a vector.}
\item{aggnu}{Aggregated empirical column measure (i.e., selection frequencies) as a vector.}
\item{aggzeta}{Aggregated empirical row measure (i.e., row weights) as a vector.}
}
\description{
{Workhorse function for the Stability Selection variant where either a grid of thresholds or a grid of
cardinalities is given so that the Boosting models are evaluated on a validation set according to all elements of
the respective grid. The model which performs best is finally selected as stable model.}
}
\details{
{The Stability Selection in the packages \code{stabs} and \code{mboost} requires to fix two of three parameters which are
the per-family error rate, the threshold and the number of variables which have to be selected in each model. Our
Stability Selection is based on another idea. We also train Boosting models on subsamples but we use a validation
step to determine the size of the optimal model. More precisely, if  \code{'pigrid'} is used as \code{gridtype}, the corresponding
stable models for each threshold are computed by selecting all variables whose aggregated selection frequency exceeds
the threshold. Then, these candidate stable models are validated according to the target loss function (inserted
through \code{evalfam}) and the optimal one is finally selected. If \code{'qgrid'} is used as \code{gridtype}, a vector of positive
integers has to be entered instead of a vector of thresholds. The candidate stable models then consist of the best
variables ordered by their aggregated selection frequencies, respectively. The validation step is the same.}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020}

{T. Hothorn, P. Bühlmann, T. Kneib, M. Schmid, and B. Hofner. mboost: Model-Based
Boosting, 2017}

{B. Hofner and T. Hothorn. stabs: Stability Selection with Error Control, 2017.}

{B. Hofner, L. Boccuto, and M. Göker. Controlling false discoveries in high-dimensional
situations: Boosting with stability selection. BMC Bioinformatics, 16(1):144, 2015.}

{N. Meinshausen and P. Bühlmann. Stability selection. Journal of the Royal Statistical Society:
Series B (Statistical Methodology), 72(4):417–473, 2010.}
}
