% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tb_burden_overview.R
\name{plot_tb_burden_overview}
\alias{plot_tb_burden_overview}
\title{Plot an overview of TB Burden for Multiple Countries}
\usage{
plot_tb_burden_overview(df = NULL, dict = NULL, metric = "e_inc_100k",
  metric_label = NULL, countries = NULL, compare_to_region = FALSE,
  facet = NULL, annual_change = FALSE, trans = "identity",
  scales = "free_y", interactive = FALSE, download_data = TRUE,
  save = TRUE, burden_save_name = "TB_burden",
  dict_save_name = "TB_data_dict", verbose = TRUE, ...)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string specifying the metric label to use.}

\item{countries}{A character string specifying the countries to plot.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{facet}{Character string, the name of the variable to facet by.}

\item{annual_change}{Logical, defaults to \code{FALSE}. If \code{TRUE} then the
percentage annual change is computed for the specified metric.}

\item{trans}{A character string specifying the transform to use on the specified metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{scales}{Character string, see ?ggplot2::facet_wrap for details. Defaults to "fixed",
alternatives are "free_y", "free_x", or "free".}

\item{interactive}{Logical, defaults to \code{FALSE}. If \code{TRUE} then an interactive plot is
returned.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. Defaults to
\code{TB_burden}.}

\item{dict_save_name}{Character string, name to save dictionary under. Defaults to
\code{TB_data_dict}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional parameters to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A dot plot of any numeric metric by country.
}
\description{
This functions returns a dot plot for a given metric over a specified
list of countries. If \code{compare_to_region} is specified then a given country will
be compared to others in its region. This enables the user to rapidly understand trends in
Tuberculosis over time and the progress towards global elimination.
}
\examples{

## Plot incidence rates over time for both the United Kingdom and Botswana
plot_tb_burden_overview(countries = c("United Kingdom", "Botswana"), 
                        compare_to_region = FALSE)
 
## Plot percentage annual change in incidence rates.
plot_tb_burden_overview(countries = c("United Kingdom", "Botswana"), 
                        compare_to_region = FALSE, annual_change = TRUE)
                         
## Compare incidence rates in the UK and Botswana to incidence rates in their regions
plot_tb_burden_overview(countries = c("United Kingdom", "Botswana"), 
                        compare_to_region = TRUE)
   
## Find variables relating to mortality in the WHO dataset
search_data_dict(def = "mortality")
                   
## Compare mortality rates (exc HIV) in the UK and Botswana to mortality rates in their regions
## Do not show progress messages
plot_tb_burden_overview(metric = "e_mort_exc_tbhiv_100k",
                        countries = c("United Kingdom", "Botswana"), 
                        compare_to_region = TRUE, verbose = FALSE)
}
\seealso{
get_tb_burden search_data_dict
}
