% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothingZone.R
\name{smoothingZone}
\alias{smoothingZone}
\title{smoothingZone}
\usage{
smoothingZone(z, width, boundary, disp = TRUE)
}
\arguments{
\item{z}{zone to be modified (SpatialPolygon)}

\item{width}{smoothing parameter in gBuffer if dilatation is followed by erosion}

\item{boundary}{union of all zones of the corrected map (result of correctBoundaryMap())}

\item{disp}{logical, if TRUE, display the value of "widthExt" in case of dilatation->erosion, otherwise display "widthInt" in case of erosion->dilatation}
}
\value{
a zone (SpatialPolygon)
}
\description{
smoothingZone
}
\details{
function that returns a new smoothed zones. Attention: this function is just a tool for a better visualisation of the map, if it
doesn't work properly, please choose another value of the width parameter.
}
\examples{
\donttest{
seed=1
map=genMap(DataObj=NULL,seed=seed,disp=FALSE,krig=2,typeMod="Exp",nPointsK=500)
criti = correctionTree(qProb = c(0.5), map = map)
Z = criti$zk[[1]][[1]]$zonePolygone
lab = criti$zk[[1]][[1]]$lab
# zones' correction
res = correctBoundaryMap(Zi = Z, map = map)
Z = res$Z
# map boundary after correction
boundary = Z[[1]]
for(i in 2:length(Z)){
  boundary = rgeos::gUnion(boundary, Z[[i]])
}
# plot map
plotM(map = map, Z = Z, lab = lab, byLab = FALSE)
# smoothing
zone = Z[[2]]
newZone = smoothingZone(z = zone, width = 0.05, boundary = boundary)
sp::plot(zone)
sp::plot(newZone)
}
}
