% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visudispZ.R
\name{dispZ}
\alias{dispZ}
\title{dispZ}
\usage{
dispZ(step, matVal, nbLvl = 0, zonePolygone = NULL, K = NULL,
  colBreaks = 0, texMain = "", boundary = NULL, id = FALSE,
  valQ = NULL, palCol = colorRampPalette(c("brown", "yellow")),
  noXY = FALSE, iZ = 0, mu = 1, cex = 1, ptz = NULL)
}
\arguments{
\item{step}{grid resolution}

\item{matVal}{data frame of values}

\item{nbLvl}{number of contour lines to generate}

\item{zonePolygone}{zoning geometry (list of SpatialPolygons)}

\item{K}{zoning object, as returned by the calNei function}

\item{colBreaks}{if vector of length 1 number of color breaks, or else color breaks themselves}

\item{texMain}{main title}

\item{boundary}{map boundary (list with x and y values)}

\item{id}{logical value (if TRUE display zone ids on plot)}

\item{valQ}{quantile values to use for contour lines}

\item{palCol}{color palette}

\item{noXY}{if TRUE do not draw axes}

\item{iZ}{index of zone to outline in red}

\item{mu}{mu=1-only display zone number or id, mu=2-also display mean zone value}

\item{cex}{text size}

\item{ptz}{zone id location, if NULL automatically find the best locations}
}
\value{
an empty value
}
\description{
dispZ
}
\details{
plots a color image representation of values and zones
}
\examples{
data(mapTest)
data(resZTest)
K=resZTest
Z=K$zonePolygone
dispZ(mapTest$step,mapTest$krigGrid)
}
