% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calCost.R
\name{Extreme_Zone}
\alias{Extreme_Zone}
\title{Extreme_Zone}
\usage{
Extreme_Zone(map, Z, numZ, label.is.min = TRUE)
}
\arguments{
\item{map}{object returned by function genMap}

\item{Z}{list of zones.}

\item{numZ}{number of the zone whose values will be approximated.}

\item{label.is.min}{boolean value that is TRUE if the label of the zone is minimum and FALSE if the label is maximum}
}
\value{
approximated values of the values in zone (numZ).
}
\description{
Extreme_Zone
}
\details{
funtion that approximates the value in a extreme zone (zone with label maximum or minimum, zones which have only one neighbour)
by the solution of the Laplace's equation. The iso contours plotted on the approximate data will take the form of concentric circles as we
supposed the extreme value of the zone is at the zone center (furthest point from the zone boundary.)
}
\examples{
\donttest{
 seed=35
 map=genMap(DataObj=NULL,seed=seed,krig=2,typeMod="Exp",nPointsK=500)
 ZK=initialZoning(qProb=c(0.8),map)
 Z=ZK$resZ$zonePolygone # list of zones
 lab = ZK$resZ$lab # label of zones
 plotM(map = map,Z = Z,lab = lab, byLab = FALSE)
 # zone 2 is a zone with maximum label
 numZ = 2
 Estimation = Extreme_Zone(map = map, Z = Z, numZ = numZ, label.is.min = FALSE)
 # compute the cost
 cL = Cost_By_Laplace(map = map, Z = Z, numZ = numZ, Estimation = Estimation)
 cM = Cost_By_Mean(map = map, Z = Z, numZ = numZ)
 print(cL$cost_Laplace)
 print(cM$cost_Mean)
 # zone 2 is homogeneous
}
}
