% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional.R
\name{vonMises}
\alias{vonMises}
\title{von Mises distribution}
\usage{
vonMises(a, mu = 0, kappa = 1, degrees = FALSE)
}
\arguments{
\item{a}{angle(s), scalar or vector}

\item{mu}{scalar containing the mean direction}

\item{kappa}{scalar containing the concentration parameter}

\item{degrees}{\code{TRUE} for degrees, \code{FALSE} for radians}
}
\value{
a scalar or vector of the same length as \code{angles}
}
\description{
Returns the probability density of a von Mises
    distribution, which describes probability distributions on a
    circle using the following density function:

    \eqn{\frac{\exp(\kappa\cos(x-\mu))}{2\pi I_0(\kappa)}}

where \eqn{I_0(\kappa)} is a zero order Bessel function.
}
\examples{
plot(x=c(-1,1.2),y=c(-1,1.2),type='n',
     axes=FALSE,ann=FALSE,bty='n',asp=1)
a <- seq(from=-pi,to=pi,length.out=200)
d <- vonMises(a=a,mu=pi/4,kappa=5)
symbols(x=0,y=0,circles=1,add=TRUE,inches=FALSE,xpd=NA,fg='grey50')
lines(x=(1+d)*cos(a),y=(1+d)*sin(a),xpd=NA)
}
