% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostan_fit-methods.R
\name{residuals.geostan_fit}
\alias{residuals.geostan_fit}
\alias{fitted.geostan_fit}
\alias{spatial}
\alias{spatial.geostan_fit}
\title{Extract residuals, fitted values, or the spatial trend}
\usage{
\method{residuals}{geostan_fit}(object, summary = TRUE, rates = TRUE, detrend = TRUE, ...)

\method{fitted}{geostan_fit}(object, summary = TRUE, rates = TRUE, trend = TRUE, ...)

spatial(object, summary = TRUE, ...)

\method{spatial}{geostan_fit}(object, summary = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{geostan_fit}.}

\item{summary}{Logical; should the values be summarized by their mean, standard deviation, and quantiles (\code{probs = c(.025, .2, .5, .8, .975)}) for each observation? Otherwise, a matrix containing samples from the posterior distributions is returned.}

\item{rates}{For Poisson and Binomial models, should the fitted values be returned as rates, as opposed to raw counts? Defaults to \code{TRUE}; see the \code{Details} section for more information.}

\item{detrend}{For auto-normal models (CAR and SAR models with Gaussian likelihood only); if \code{detrend = TRUE}, the implicit spatial trend will be removed from the residuals. The implicit spatial trend is \code{Trend = rho * C \%*\% (Y - Mu)} (see \link[geostan]{stan_car} or \link[geostan]{stan_sar}). I.e., \code{resid = Y - (Mu + Trend)}.}

\item{...}{Not used}

\item{trend}{For auto-normal models (CAR and SAR models with Gaussian likelihood only); if \code{trend = TRUE}, the fitted values will include the implicit spatial trend term. The implicit spatial trend is \code{Trend = rho * C \%*\% (Y - Mu)} (see \link[geostan]{stan_car} or \link[geostan]{stan_sar}). I.e., if \code{trend = TRUE}, \code{fitted = Mu + Trend}.}
}
\value{
By default, these methods return a \code{data.frame}. The column named \code{mean} is what most users will be looking for. These contain the fitted values (for the \code{fitted} method), the residuals (fitted values minus observed values, for the \code{resid} method), or the spatial trend (for the \code{spatial} method). The \code{mean} column is the posterior mean of each value, and the column \code{sd} contains the posterior standard deviation for each value. The posterior distributions are also summarized by select quantiles (including 2.5\\% and 97.5\\%).

If \code{summary = FALSE} then the method returns an S-by-N matrix of MCMC samples, where S is the number of MCMC samples and N is the number of observations in the data.
}
\description{
Extract model residuals, fitted values, or spatial trend from a fitted \code{geostan_fit} model.
}
\details{
When \code{rates = FALSE} and the model is Poisson or Binomial, the fitted values returned by the \code{fitted} method are the expected value of the response variable. The \code{rates} argument is used to translate count outcomes to rates by dividing by the appropriate denominator. The behavior of the \code{rates} argument depends on the model specification. Consider a Poisson model of disease incidence, such as the following intercept-only case:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fit <- stan_glm(y ~ offset(log(E)),
               data = data,
               family = poisson())
}\if{html}{\out{</div>}}

If the fitted values are extracted using \code{rates = FALSE}, then \code{fitted(fit)} will return the expectation of \eqn{y}. If \code{rates = TRUE} (the default), then \code{fitted(fit)} will return the expected value of the rate \eqn{\frac{y}{E}}.

If a binomial model is used instead of the Poisson, then using \code{rates = TRUE} will return the expectation of \eqn{\frac{y}{N}} where \eqn{N} is the sum of the number of 'successes' and 'failures', as in:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fit <- stan_glm(cbind(successes, failures) ~ 1,
               data = data,
               family = binomial())
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
data(georgia)
A <- shape2mat(georgia, "B")

fit <- stan_esf(deaths.male ~ offset(log(pop.at.risk.male)),
                C = A,
                data = georgia,
                family = poisson(),
                chains = 1, iter = 600) # for speed only


# Residuals
r <- resid(fit)
moran_plot(r$mean, A)
head(r)

# Fitted values
f <- fitted(fit)

# Fitted values, unstandardized
f <- fitted(fit, rates = FALSE)
head(f)

# Spatial trend
esf <- spatial(fit)
head(esf)
}
}
