% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{get_shp}
\alias{get_shp}
\title{Download shapefiles}
\usage{
get_shp(url, folder = "shape")
}
\arguments{
\item{url}{url to download a shapefile.}

\item{folder}{what to name the new folder in your working directory containing the shapefile}
}
\value{
A folder in your working directory with the shapefile; filepaths are printed to the console.
}
\description{
Given a url to a shapefile in a compressed .zip file, download the file and unzip it into a folder in your working directory.
}
\examples{
\dontrun{
library(sf)
url <- "https://www2.census.gov/geo/tiger/GENZ2019/shp/cb_2019_us_state_20m.zip"
folder <- tempdir()
print(folder)
get_shp(url, folder)
states <- sf::st_read(folder)
head(states)
}
}
