% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midpoint.R
\name{geo_midpoint}
\alias{geo_midpoint}
\title{Midpoint}
\usage{
geo_midpoint(from, to)
}
\arguments{
\item{from}{\link{Feature}<\link{Point}> first point}

\item{to}{\link{Feature}<\link{Point}> second point}
}
\value{
\link{Feature}<\link{Point}> a point midway between \code{from} and \code{to}
}
\description{
Takes two \link{Point}'s and returns a point midway between them.
The midpoint is calculated geodesically, meaning the curvature of
the earth is taken into account.
}
\examples{
pt1 <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [144.834823, -37.771257]
  }
}'
pt2 <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [145.14244, -37.830937]
  }
}'

geo_midpoint(pt1, pt2)
}
