% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/picknplot.shape.r
\name{picknplot.shape}
\alias{picknplot.shape}
\title{Pick points in geomorph scatterplots to visualize shape variation}
\usage{
picknplot.shape(x, ...)
}
\arguments{
\item{x}{a geomorph plot object of class plot.gm.prcomp, plot.procD.lm, plot.pls, or plotAllometry}

\item{...}{other arguments passed to \code{\link{plotRefToTarget}}}
}
\value{
A list with the following components:
\item{points}{A list with the xy coordinates of the selected points.}
\item{shapes}{A list with the corresponding estimated shapes.}
}
\description{
Function plots the shape corresponding to a clicked point in the area of a geomorph plot
}
\details{
THIS FUNCTION IS A BIT EXPERIMENTAL!  

This function recycles scatter plots generated by \code{\link{plot.gm.prcomp}}, \code{\link{plot.procD.lm}}, 
\code{\link{plot.pls}}, or \code{\link{plotAllometry}}, and makes them interactive to visualize shape variation by selecting one or more points in morphospace. 
The function uses \code{\link{shape.predictor}} 
to estimate the shape corresponding to the selected point(s) based on the prediction underlying the scatterplot, and it plots the estimated 
shape as compared to the consensus landmark configuration using \code{\link{plotRefToTarget}}. The user is then prompted as to whether the plotted
shape is to be saved as a png file, in which case the name of the file needs to be provided (without quotation marks).
Interactive plots are at present available for plots produced by \code{\link{plot.gm.prcomp}}.  The function is limited in terms of the options for 
\code{\link{plotRefToTarget}} (because of the complexity of graphics); using \code{\link{shape.predictor}} and \code{\link{plotRefToTarget}}, directly, 
will always offer more flexibility.

IF YOU EXPERIENCE AN ERROR, please use \code{\link{shape.predictor}} and \code{\link{plotRefToTarget}}, directly.  (But please alert the 
geomorph package maintainer.)
}
\examples{

### Because picknplot requires user decisions, the following examples
### are not run (but can be with removal of #s)

# 2d
# data(plethodon) 
# Y.gpa <- gpagen(plethodon$land)
# pleth.pca <- gm.prcomp(Y.gpa$coords)
# pleth.pca.plot <- plot(pleth.pca)
# picknplot.shape(pleth.pca.plot) 
# May change arguments for plotRefToTarget
# picknplot.shape(plot(pleth.pca), method = "points", mag = 3, links=plethodon$links)

# 2d with phylogeny
# data(plethspecies) 
# Y.gpa <- gpagen(plethspecies$land)
# gps <- as.factor(c(rep("gp1", 5), rep("gp2", 4))) # Two random groups
# pleth.phylo <- gm.prcomp(Y.gpa$coords, plethspecies$phy)
# pleth.phylomorphospace <- plot(pleth.phylo, phylo = TRUE, cex = 2, pch = 22, 
# bg = gps, phylo.par = list(edge.color = "blue", edge.width = 2, edge.lty = 2,
# node.pch = 22, node.bg = "black"))
# links.species <- plethodon$links[-11,]
# links.species[11, 1] <- 11
# picknplot.shape(pleth.phylomorphospace, method = "points", links = links.species)

# 2d allometry 
# gdf <- geomorph.data.frame(Y.gpa, site = plethodon$site, 
# species = plethodon$species) 
# fit <- procD.lm(coords ~ log(Csize), data=gdf, iter=0, print.progress = FALSE)
# Predline
# PA <- plotAllometry(fit, size = gdf$Csize, logsz = TRUE, method = "PredLine", pch = 19)
# picknplot.shape(PA)

# 3d and two-b-pls
# data("scallops")
# Y.gpa <- gpagen(scallops$coorddata, curves = scallops$curvslide, 
#              surfaces = scallops$surfslide)
# PLS <- two.b.pls(Y.gpa$coords, Y.gpa$Csize)
# PLS.plot = plot(PLS)
# picknplot.shape(PLS.plot)
}
\seealso{
\code{\link{shape.predictor}}, \code{\link{plotRefToTarget}}

\code{\link[rgl]{rgl-package}} (used in 3D plotting)
}
\author{
Antigoni Kaliontzopoulou, Emma Sherratt, & Michael Collyer
}
\keyword{visualization}
