% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.CR.R
\name{compare.CR}
\alias{compare.CR}
\title{Comparisons of Effect Sizes from Modularity Analyses}
\usage{
compare.CR(..., CR.null = TRUE, two.tailed = TRUE)
}
\arguments{
\item{...}{saved analyses of class CR}

\item{CR.null}{A logical value to indicate whether a Null CR model (no modularity) should also be included in analysis.}

\item{two.tailed}{A logical value to indicate whether a two-tailed test (typical and default) should be performed.}
}
\value{
An object of class compare.CR, returns a list of the following
\item{sample.z}{A vector of effect sizes for each sample.}
\item{sample.r.sd}{A vector of standard deviations for each sampling distribution.}
\item{pairwise.z}{A matrix of pairwise, two-sample z scores between all pairs of effect sizes.}
\item{pairwise.p}{A matrix of corresponding P-values.}
}
\description{
Function performs an analysis to compare the effect sizes of two or more CR effects
}
\details{
The function statistically compares the effect sizes of two or more CR analyses.  Typically, this
function might be used to compare levels of modularity between two or more samples, each measuring the degree 
of morphological modularity in each.  Alternatively, the approach can compare the degree of modular signal as 
expressed by alternative modular hypotheses for the same dataset.

The analysis calculates effect sizes as standard deviates, z, and performs two-sample z-tests, using the pooled 
standard error from the sampling distributions of the CR analyses. The method follows that of Adams and Collyer (2019) used 
to compare patterns of integration via PLS across datasets
 
To use this function, simply perform \code{\link{modularity.test}}, or \code{\link{phylo.modularity}} on as many samples or 
alternative modular hypotheses as desired.  Any number of objects of class CR can be input. For the case of the latter, one may wish to
include the null hypothesis of no modularity (i.e., that all variables belong to a single module). For this, the CR.null = TRUE option
should be specified. Finally, one may perform the comparison as either a one-tailed or a two-tailed (default) test.
}
\examples{

### NOT RUN
# Example 1: Compare modular signal across datasets

# data(pupfish) 
# Y.gpa<-gpagen(pupfish$coords, print.progress = FALSE)    #GPA-alignment    
## landmarks on the body and operculum
# land.gps<-rep('a',56); land.gps[39:48]<-'b'

# group <- factor(paste(pupfish$Pop, pupfish$Sex, sep = "."))
# levels(group)

# coords.gp <- coords.subset(Y.gpa$coords, group)

# modularity.tests <- lapply(1:nlevels(group), function(j) modularity.test(coords.gp[[j]],
#  land.gps, iter = 499, print.progress = FALSE))
## the lapply function performs the modularity test on each 3D array in the lists provided

# modularity.tests[[1]]
# modularity.tests[[2]]
# modularity.tests[[3]]
# modularity.tests[[4]]

# group.Z <- compare.CR(modularity.tests, CR.null = FALSE)
# group.Z  ## NOTE: need a summary function 

# Example 2: Compare alternative modular hypotheses

# land.gps3 <- rep('a',56); land.gps3[39:48]<-'b'; land.gps3[c(6:9,28:38)] <- 'c' 
   #3 module hypothesis (tail now a module)
# land.gps4 <- rep('a',56); land.gps4[39:48]<-'b'; land.gps4[c(6:9,28:38)] <- 'c'; 
 # land.gps4[c(10,49:56)] <- 'd'  #4 module hypothesis (eye now a module)

# m3.test <- modularity.test(coords.gp$Marsh.F,land.gps3, iter = 499, print.progress = FALSE)
# m4.test <- modularity.test(coords.gp$Marsh.F,land.gps4, iter = 499, print.progress = FALSE)

# model.Z <- compare.CR(modularity.tests[[1]],m3.test,m4.test, CR.null = TRUE)
# model.Z 

}
\references{
Adams, D.C. and M.L. Collyer. 2019.  Comparing the strength of modular signal, and evaluating alternative modular hypotheses,
using covariance ratio effect sizes for morphometric data. *Evolution*. (Accepted).
}
\author{
Dean Adams and Michael Collyer
}
\keyword{analysis}
