% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOServiceIdentification.R
\docType{class}
\name{ISOSRVServiceIdentification}
\alias{ISOSRVServiceIdentification}
\title{ISOSRVServiceIdentification}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO ServiceIdentification
}
\description{
ISOSRVServiceIdentification

ISOSRVServiceIdentification
}
\examples{
  #encoding
  md <- ISOSRVServiceIdentification$new()
  md$setAbstract("abstract")
  md$setPurpose("purpose")

  #adding a point of contact
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone")
  rp$setOrganisationName("somewhere")
  rp$setPositionName("someposition")
  rp$setRole("pointOfContact")
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  rp$setContactInfo(contact)
  md$addPointOfContact(rp)

  #citation
  ct <- ISOCitation$new()
  ct$setTitle("sometitle")
  d <- ISODate$new()
  d$setDate(ISOdate(2015, 1, 1, 1))
  d$setDateType("publication")
  ct$addDate(d)
  ct$setEdition("1.0")
  ct$setEditionDate(ISOdate(2015,1,1))
  ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
  ct$addPresentationForm("mapDigital")
  ct$addCitedResponsibleParty(rp)
  md$setCitation(ct)

  #graphic overview
  go <- ISOBrowseGraphic$new(
    fileName = "http://wwww.somefile.org/png",
    fileDescription = "Map Overview",
    fileType = "image/png"
  )
  md$addGraphicOverview(go)

  #maintenance information
  mi <- ISOMaintenanceInformation$new()
  mi$setMaintenanceFrequency("daily")
  md$addResourceMaintenance(mi)

  #adding legal constraints
  lc <- ISOLegalConstraints$new()
  lc$addUseLimitation("limitation1")
  lc$addUseLimitation("limitation2")
  lc$addUseLimitation("limitation3")
  lc$addAccessConstraint("copyright")
  lc$addAccessConstraint("license")
  lc$addUseConstraint("copyright")
  lc$addUseConstraint("license")
  md$addResourceConstraints(lc)

  #specific elements to service identification
  md$setServiceType("Fishery data harmonization process")
  md$addServiceTypeVersion("1.0")
  orderProcess <- ISOStandardOrderProcess$new()
  orderProcess$setFees("fees")
  orderProcess$setPlannedAvailableDateTime(ISOdate(2017,7,5,12,0,0))
  orderProcess$setOrderingInstructions("instructions")
  orderProcess$setTurnaround("turnaround")
  md$setAccessProperties(orderProcess)
  md$setRestrictions(lc)

  kwds <- ISOKeywords$new()
  kwds$addKeyword("keyword1")
  kwds$addKeyword("keyword2")
  kwds$setKeywordType("theme")
  th <- ISOCitation$new()
  th$setTitle("General")
  th$addDate(d)
  kwds$setThesaurusName(th)
  md$addKeywords(kwds)

  #adding extent
  extent <- ISOExtent$new()
  bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
  extent$addGeographicElement(bbox)
  md$addExtent(extent)

  #coupling type
  #(here "tight" associated with a particular dataset "my-dataset-identifier")
  #see ISOCouplingType$values(labels = T) for other values
  md$setCouplingType("tight")
  coupledDataset1 <- ISOCoupledResource$new()
  coupledDataset1$setOperationName("Rscript")
  coupledDataset1$setIdentifier("my-dataset-identifier")
  coupledDataset2 <- ISOCoupledResource$new()
  coupledDataset2$setOperationName("WPS:Execute")
  coupledDataset2$setIdentifier("my-dataset-identifier")
  md$addCoupledResource(coupledDataset1)
  md$addCoupledResource(coupledDataset2)

  #add operation metadata 1 (Rscript)
  scriptOp <- ISOOperationMetadata$new()
  scriptOp$setOperationName("Rscript")
  scriptOp$addDCP("WebServices")
  scriptOp$setOperationDescription("WPS Execute")
  scriptOp$setInvocationName("identifier")
  for(i in 1:3){
    param <- ISOSRVParameter$new()
    param$setName(sprintf("name\%s",i), "xs:string")
    param$setDirection("in")
    param$setDescription(sprintf("description\%s",i))
    param$setOptionality(FALSE)
    param$setRepeatability(FALSE)
    param$setValueType("xs:string")
    scriptOp$addParameter(param)
  }
  outParam <-ISOSRVParameter$new()
  outParam$setName("outputname", "xs:string")
  outParam$setDirection("out")
  outParam$setDescription("outputdescription")
  outParam$setOptionality(FALSE)
  outParam$setRepeatability(FALSE)
  outParam$setValueType("xs:string")
  scriptOp$addParameter(outParam)
  or <- ISOOnlineResource$new()
  or$setLinkage("http://somelink/myrscript.R")
  or$setName("R script name")
  or$setDescription("R script description")
  or$setProtocol("protocol")
  scriptOp$addConnectPoint(or)
  md$addOperationMetadata(scriptOp)
  #add operation metadata 1 (WPS)
  wpsOp <- ISOOperationMetadata$new()
  wpsOp$setOperationName("WPS:Execute")
  wpsOp$addDCP("WebServices")
  wpsOp$setOperationDescription("WPS Execute")
  invocationName <- "mywpsidentifier"
  wpsOp$setInvocationName(invocationName)
  for(i in 1:3){
    param <- ISOSRVParameter$new()
    param$setName(sprintf("name\%s",i), "xs:string")
    param$setDirection("in")
    param$setDescription(sprintf("description\%s",i))
    param$setOptionality(FALSE)
    param$setRepeatability(FALSE)
    param$setValueType("xs:string")
    wpsOp$addParameter(param)
  }
  outParam <-ISOSRVParameter$new()
  outParam$setName("outputname", "xs:string")
  outParam$setDirection("out")
  outParam$setDescription("outputdescription")
  outParam$setOptionality(FALSE)
  outParam$setRepeatability(FALSE)
  outParam$setValueType("xs:string")
  wpsOp$addParameter(outParam)
  or1 <- ISOOnlineResource$new()
  or1$setLinkage(
    sprintf("http://somelink/wps?request=Execute&version=1.0.0&Identifier=\%s",
    invocationName)
  )
  or1$setName("WPS process name")
  or1$setDescription("WPS process description")
  or1$setProtocol("protocol")
  wpsOp$addConnectPoint(or1)
  or2 <- ISOOnlineResource$new()
  or2$setLinkage("http://somelink/myrscript.R")
  or2$setName("Source R script name")
  or2$setDescription("Source R script description")
  or2$setProtocol("protocol")
  wpsOp$addConnectPoint(or2)
  md$addOperationMetadata(wpsOp)
  xml <- md$encode()
   
}
\references{
- ISO 19119 \url{https://schemas.isotc211.org/19119/srv/srv/#element_SV_ServiceIdentification}
  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/srv/2.0/srv/#element_SV_ServiceIdentification}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{identification}
\keyword{service}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{\link[geometa:ISOServiceIdentification]{geometa::ISOServiceIdentification}} -> \code{ISOSRVServiceIdentification}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{serviceType}}{serviceType [1..1]: ISOGenericName}

\item{\code{serviceTypeVersion}}{serviceTypeVersion [0..*]: character}

\item{\code{accessProperties}}{accessProperties [0..1]: ISOStandardOrderProcess}

\item{\code{restrictions}}{restrictions [0..1]: ISOConstraints}

\item{\code{keywords}}{keywords [0..*]: ISOKeywords}

\item{\code{extent}}{extent [0..*]: ISOExtent}

\item{\code{coupledResource}}{coupledResource [0..*]: ISOCoupledResource}

\item{\code{couplingType}}{couplingType [1..1]: ISOCouplingType}

\item{\code{containsOperations}}{containsOperations [1..*]: ISOOperationMetadata}

\item{\code{operatesOn}}{operatesOn [0..*]: ISODataIdentification}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOSRVServiceIdentification-new}{\code{ISOSRVServiceIdentification$new()}}
\item \href{#method-ISOSRVServiceIdentification-setServiceType}{\code{ISOSRVServiceIdentification$setServiceType()}}
\item \href{#method-ISOSRVServiceIdentification-addServiceTypeVersion}{\code{ISOSRVServiceIdentification$addServiceTypeVersion()}}
\item \href{#method-ISOSRVServiceIdentification-delServiceTypeVersion}{\code{ISOSRVServiceIdentification$delServiceTypeVersion()}}
\item \href{#method-ISOSRVServiceIdentification-setAccessProperties}{\code{ISOSRVServiceIdentification$setAccessProperties()}}
\item \href{#method-ISOSRVServiceIdentification-setRestrictions}{\code{ISOSRVServiceIdentification$setRestrictions()}}
\item \href{#method-ISOSRVServiceIdentification-addKeywords}{\code{ISOSRVServiceIdentification$addKeywords()}}
\item \href{#method-ISOSRVServiceIdentification-delKeywords}{\code{ISOSRVServiceIdentification$delKeywords()}}
\item \href{#method-ISOSRVServiceIdentification-addExtent}{\code{ISOSRVServiceIdentification$addExtent()}}
\item \href{#method-ISOSRVServiceIdentification-delExtent}{\code{ISOSRVServiceIdentification$delExtent()}}
\item \href{#method-ISOSRVServiceIdentification-addCoupledResource}{\code{ISOSRVServiceIdentification$addCoupledResource()}}
\item \href{#method-ISOSRVServiceIdentification-delCoupledResource}{\code{ISOSRVServiceIdentification$delCoupledResource()}}
\item \href{#method-ISOSRVServiceIdentification-setCouplingType}{\code{ISOSRVServiceIdentification$setCouplingType()}}
\item \href{#method-ISOSRVServiceIdentification-addOperationMetadata}{\code{ISOSRVServiceIdentification$addOperationMetadata()}}
\item \href{#method-ISOSRVServiceIdentification-delOperationMetadata}{\code{ISOSRVServiceIdentification$delOperationMetadata()}}
\item \href{#method-ISOSRVServiceIdentification-addOperatesOn}{\code{ISOSRVServiceIdentification$addOperatesOn()}}
\item \href{#method-ISOSRVServiceIdentification-delOperatesOn}{\code{ISOSRVServiceIdentification$delOperatesOn()}}
\item \href{#method-ISOSRVServiceIdentification-clone}{\code{ISOSRVServiceIdentification$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-setServiceType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-setServiceType}{}}}
\subsection{Method \code{setServiceType()}}{
Set service type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$setServiceType(serviceType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceType}}{object of class \link{ISOLocalName}, \link{ISOScopedName} or \link{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-addServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-addServiceTypeVersion}{}}}
\subsection{Method \code{addServiceTypeVersion()}}{
Adds service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$addServiceTypeVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-delServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-delServiceTypeVersion}{}}}
\subsection{Method \code{delServiceTypeVersion()}}{
Deletes service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$delServiceTypeVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-setAccessProperties"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-setAccessProperties}{}}}
\subsection{Method \code{setAccessProperties()}}{
Set access properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$setAccessProperties(accessProperties)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accessProperties}}{object of class \link{ISOStandardOrderProcess}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-setRestrictions"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-setRestrictions}{}}}
\subsection{Method \code{setRestrictions()}}{
Set restrictions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$setRestrictions(restrictions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{restrictions}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-addKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-addKeywords}{}}}
\subsection{Method \code{addKeywords()}}{
Adds keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$addKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-delKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-delKeywords}{}}}
\subsection{Method \code{delKeywords()}}{
Deletes keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$delKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-addExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-addExtent}{}}}
\subsection{Method \code{addExtent()}}{
Adds extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$addExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-delExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-delExtent}{}}}
\subsection{Method \code{delExtent()}}{
Deletes extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$delExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-addCoupledResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-addCoupledResource}{}}}
\subsection{Method \code{addCoupledResource()}}{
Adds coupled resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$addCoupledResource(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{object of class \link{ISOCoupledResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-delCoupledResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-delCoupledResource}{}}}
\subsection{Method \code{delCoupledResource()}}{
Deletes coupled resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$delCoupledResource(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{object of class \link{ISOCoupledResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-setCouplingType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-setCouplingType}{}}}
\subsection{Method \code{setCouplingType()}}{
Set coupling type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$setCouplingType(couplingType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{couplingType}}{object of class \link{ISOCouplingType} or any \link{character}
among values returned by \code{ISOCouplingType$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-addOperationMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-addOperationMetadata}{}}}
\subsection{Method \code{addOperationMetadata()}}{
Adds operation metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$addOperationMetadata(operationMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operationMetadata}}{object of class \link{ISOOperationMetadata}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-delOperationMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-delOperationMetadata}{}}}
\subsection{Method \code{delOperationMetadata()}}{
Deletes operation metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$delOperationMetadata(operationMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operationMetadata}}{object of class \link{ISOOperationMetadata}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-addOperatesOn"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-addOperatesOn}{}}}
\subsection{Method \code{addOperatesOn()}}{
Adds operates on
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$addOperatesOn(dataIdentification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataIdentification}}{object of class \link{ISODataIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-delOperatesOn"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-delOperatesOn}{}}}
\subsection{Method \code{delOperatesOn()}}{
Deletes operates on
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$delOperatesOn(dataIdentification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataIdentification}}{object of class \link{ISODataIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
