% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryGCPCollection.R
\docType{class}
\name{ISOImageryGCPCollection}
\alias{ISOImageryGCPCollection}
\title{ISOImageryGCPCollection}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery gcp collection
}
\description{
ISOImageryGCPCollection
}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryGCPCollection}}
 }
 \item{\code{setCollectionIdentification(id)}}{
   Set the identifier, object of class \code{integer}
 }
 \item{\code{setCollectionName(name, locales)}}{
   Sets a name (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setCoordinateReferenceSystem(crs)}}{
   Sets the crs, object of class \code{\link{ISOReferenceSystem}}
 }
 \item{\code{addGCP(gcp)}}{
   Adds a GCP, object of class \code{\link{ISOImageryGCP}}
 }
 \item{\code{delGCP(gcp)}}{
   Deletes a GCP, object of class \code{\link{ISOImageryGCP}}
 }
}
}

\examples{
  md <- ISOImageryGCPCollection$new()
  md$setCollectionIdentification(1L)
  md$setCollectionName("name")
  rs <- ISOReferenceSystem$new()
  rsId <- ISOReferenceIdentifier$new(code = "4326", codeSpace = "EPSG")
  rs$setReferenceSystemIdentifier(rsId)
  md$setCoordinateReferenceSystem(rs)
  xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{collection}
\keyword{gcp}
\keyword{imagery}
