% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOGeometricObjects.R
\docType{class}
\name{ISOGeometricObjects}
\alias{ISOGeometricObjects}
\title{ISOGeometricObjects}
\format{\code{\link{R6Class}} object.}
\usage{
ISOGeometricObjects
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO GeometricObjects
}
\description{
ISOGeometricObjects
}
\section{Fields}{

\describe{
\item{\code{geometricObjectType}}{}

\item{\code{geometricObjectCount}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOGeometricObjects
 }
 \item{\code{setGeometricObjectType(geometricObjectType)}}{
   Sets the type of geometric object
 }
 \item{\code{setGeometricObjectCount(geometricObjectCount)}}{
   Sets the count of geometric objects
 }
}
}
\examples{
md <- ISOGeometricObjects$new()
  md$setGeometricObjectType("surface")
  md$setGeometricObjectCount(5L)
  xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{geometry}
\keyword{objects}

