#' ISOBaseTimeBeginPosition
#'
#' @docType class
#' @importFrom R6 R6Class
#' @export
#' @keywords ISO begin position
#' @return Object of \code{\link{R6Class}} for modelling an ISO Time begin position
#' @format \code{\link{R6Class}} object.
#'
#' @field value
#'
#' @section Methods:
#' \describe{
#'  \item{\code{new(xml,value)}}{
#'    This method is used to instantiate an ISOBaseTimeBeginPosition
#'  }
#' }
#' 
#' @note Class used by geometa internal XML decoder/encoder
#' 
#' @author Emmanuel Blondel <emmanuel.blondel1@@gmail.com>
#'
ISOBaseTimeBeginPosition <- R6Class("ISOBaseTimeBeginPosition",
  inherit = ISOMetadataElement,
  private = list(
   xmlElement = "beginPosition",
   xmlNamespacePrefix = "GML"
  ),
  public = list(
   wrap = FALSE,
   value = NA,
   attrs = list(),
   initialize = function(xml = NULL, value){
     super$initialize(
       xml = xml,
       element = private$xmlElement,
       namespace = getISOMetadataNamespace(private$xmlNamespacePrefix)
     )
     if(is.null(xml)){
       if(all(class(value)==c("POSIXct","POSIXt"))){
         value <- format(value,"%Y-%m-%dT%H:%M:%S")
       }else if(class(value) == "Date"){
         value <- format(value,"%Y-%m-%d")
       }
       self$value = value
     }
   }
  )                        
)