% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{geo_filter}
\alias{geo_filter}
\title{Filter to Intersecting Pieces}
\usage{
geo_filter(from, to, bool = FALSE, epsg = 3857)
}
\arguments{
\item{from}{Required. sf dataframe. the geography to subset}

\item{to}{Required. sf dataframe. the geography that from must intersect}

\item{bool}{Optional, defaults to FALSE. Should this just return a logical vector?}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
sf data frame or logical vector if bool == TRUE
}
\description{
Filter to Intersecting Pieces
}
\examples{
\dontrun{
# Needs Census Bureau API
data(towns)
block <- create_block_table('NY', 'Rockland')
geo_filter(block, towns)
}

data(towns)
data(rockland)
sub <- geo_filter(rockland, towns)

}
\concept{datatable}
