% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_acs_5ye_get_geo.R
\name{get_legal_and_administrative_areas}
\alias{get_legal_and_administrative_areas}
\alias{get_legal_and_administrative_areas.uscb_acs_5ye}
\title{Get Legal and Administrative Area names}
\usage{
get_legal_and_administrative_areas(ua)

\method{get_legal_and_administrative_areas}{uscb_acs_5ye}(ua)
}
\arguments{
\item{ua}{A \code{uscb_acs_5ye} object.}
}
\value{
A vector of names.
}
\description{
Returns a list of area names for which geodatabases are available.
}
\examples{
library(tidyr)

folder <- "../geodimension/data/us/"
ua <- uscb_acs_5ye(folder = folder)
laa <- ua \%>\% get_legal_and_administrative_areas()

}
\seealso{


Other data collection functions: 
\code{\link{download_geodatabases}()},
\code{\link{get_available_years_downloaded}()},
\code{\link{get_available_years_in_the_web}()},
\code{\link{get_statistical_areas}()},
\code{\link{uscb_acs_5ye}()}
}
\concept{data collection functions}
