% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r, R/plotProcessedData.r, R/plotRawData.r
\docType{methods}
\name{plot,Profile,ANY-method}
\alias{plot,Profile,ANY-method}
\alias{plot}
\alias{plotProcessedData}
\alias{plotProcessedDataWithTopo}
\alias{plotRawData}
\alias{plotRawDataWithTopo}
\title{Plot Geoelectrics Data Points}
\usage{
\S4method{plot}{Profile,ANY}(x, dataType = "processed", withTopo = T,
  xlab = "Length [m]", ylab = "Height [m]", main = paste(x@title,
  "with topography"), asp = 1, ...)

plotProcessedData(x, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(x@title, "without topography"), ...)

plotProcessedDataWithTopo(x, xlab = "Length [m]", ylab = "Height [m]",
  main = paste(x@title, "with topography"), ...)

plotRawData(x, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(x@title, "without topography"), ...)

plotRawDataWithTopo(x, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(x@title, "with topography"),
  height = x@processedData@height, spline = TRUE, ...)
}
\arguments{
\item{x}{profile object.}

\item{dataType}{specify whether 'processed' (default) or 'raw' data should be plotted}

\item{withTopo}{TRUE if topography information is plotted}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{asp}{the y/x aspect ratio (default: 1).}

\item{...}{plot parameters (such as pch, cex, col, ...).}

\item{height}{topo data frame of distances and height.}

\item{spline}{if TRUE spline interpolation is conducted.}
}
\description{
Plots the geoelectrics data points of a profile.
}
\examples{
data(sinkhole)

plot(sinkhole@profiles[[1]], dataType = 'processed', withTopo = FALSE)
plotProcessedData(sinkhole@profiles[[1]])

plot(sinkhole@profiles[[1]], dataType = 'processed', withTopo = TRUE)
plotProcessedDataWithTopo(sinkhole@profiles[[1]])

plot(sinkhole@profiles[[1]], dataType = 'raw', withTopo = FALSE)
plotRawData(sinkhole@profiles[[1]])

plot(sinkhole@profiles[[1]], dataType = 'raw', withTopo = TRUE)
plotRawDataWithTopo(sinkhole@profiles[[1]])
}
\seealso{
\code{\link{Profile-class}}, \code{\link{plot3d}},
\code{\link{levelplot}}
}
