# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate the fractal dimension of a raster (C function).
#'
#' Calculates the 3D fractal dimension of a raster using the
#' triangular prism surface area method.
#'
#' @param mat A matrix.
#' @return A numeric value representing the fractal dimension of
#' the image.
#' @references Clarke, K.C., 1986. Computation of the fractal dimension of topographic
#' surfaces using the triangular prism surface area method. Computers & Geosciences,
#' 12(5), pp.713-722.
#' @examples
#'
#' # import raster image
#' data(normforest)
#'
#' # convert to matrix
#' mat <- raster::as.matrix(normforest)
#'
#' # calculate the fractal dimension
#' Sfd <- sfd_(mat)
#' @export
sfd_ <- function(mat) {
    .Call(`_geodiv_sfd_`, mat)
}

