% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{sku}
\alias{sku}
\title{Calculates the Kurtosis of Raster Values}
\usage{
sku(x, excess = TRUE)
}
\arguments{
\item{x}{A raster or matrix.}

\item{excess}{Logical, defaults to \code{TRUE}. If
\code{TRUE}, excess kurtosis is calculated. If \code{FALSE},
kurtosis is calculated as the difference from the
normal distribution.}
}
\value{
A numeric value representing kurtosis.
}
\description{
Finds the kurtosis for a distribution of raster or matrix
values (Sku). Kurtosis represents the peakedness
of the raster surface height distribution. Height
is measured as the value of a raster/matrix and may not
necessarily represent actual height.
}
\examples{
# import raster image
data(normforest)

# find the excess kurtosis of the raster distribution
Sku <- sku(normforest, excess = TRUE)
}
