% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{eval_parameters}
\alias{eval_parameters}
\title{Worker function}
\usage{
eval_parameters(
  algo,
  parameters,
  data,
  nblistw = NULL,
  window = NULL,
  standardize = TRUE,
  spconsist = FALSE,
  classidx = TRUE,
  nrep = 30,
  indices = NULL,
  tol,
  maxiter,
  seed = NULL,
  init = "random",
  verbose = TRUE
)
}
\arguments{
\item{algo}{A string indicating which method to use (FCM, GFCM, SFCM, SGFCM)}

\item{parameters}{A dataframe of parameters with columns k,m and alpha}

\item{data}{A dataframe with numeric columns}

\item{nblistw}{A list.w object describing the neighbours typically produced
by the spdep package. Required if data is a dataframe, see the parameter window
if you use a list of rasters as input.}

\item{window}{If data is a list of rasters, then a window must be specified instead of
a list.w object. It will be used to calculate a focal function on each raster. The
window must be a square numeric matrix with odd dimensions (such 3x3). The values in
the matrix indicate the weight to give to each pixel and the centre of the matrix is
the centre of the focal function.}

\item{standardize}{A boolean to specify if the variable must be centered and
reduce (default = True)}

\item{spconsist}{A boolean indicating if the spatial consistency must be
calculated}

\item{classidx}{A boolean indicating if the quality of classification
indices must be calculated}

\item{nrep}{An integer indicating the number of permutation to do to simulate
the random distribution of the spatial inconsistency. Only used if spconsist
is TRUE.}

\item{indices}{A character vector with the names of the indices to calculate, to
evaluate clustering quality. default is :c("Silhouette.index", "Partition.entropy",
"Partition.coeff", "XieBeni.index", "FukuyamaSugeno.index", "Explained.inertia").
Other available indices are : "DaviesBoulin.index", "CalinskiHarabasz.index",
"GD43.index", "GD53.index" and "Negentropy.index".}

\item{tol}{The tolerance criterion used in the evaluateMatrices function for
convergence assessment}

\item{maxiter}{An integer for the maximum number of iteration}

\item{seed}{An integer used for random number generation. It ensures that the
start centers will be the same if the same integer is selected.}

\item{init}{A string indicating how the initial centers must be selected. "random"
indicates that random observations are used as centers. "kpp" use a distance based method
resulting in more dispersed centers at the beginning. Both of them are heuristic.}

\item{verbose}{A boolean indicating if a progressbar should be displayed}
}
\value{
a DataFrame containing for each combinations of parameters several clustering
quality indexes.
}
\description{
Worker function for select_parameters and select_parameters.mc
}
\examples{
#No example provided, this is an internal function
}
\keyword{internal}
