% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_health_facilities.R
\name{read_health_facilities}
\alias{read_health_facilities}
\title{Download geolocated data of health facilities}
\usage{
read_health_facilities(showProgress = TRUE)
}
\arguments{
\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
Data comes from the National Registry of Healthcare facilities (Cadastro
Nacional de Estabelecimentos de Saude - CNES), originally collected by the
Brazilian Ministry of Health. According to the Ministry of Health: "The
coordinates of each facility were obtained by CNES and validated by means of
space operations. These operations verify if the point is in the municipality,
considering a radius of 5,000 meters. When the coordinate is not correct,
further searches are done in other systems of the Ministry of Health and in
web services like Google Maps. Finally, if the coordinates have been correctly
obtained in this process, the coordinates of the municipal head office are
used. The geocode source used is registered in the database in a specific
column \code{data_source}. Periodically the coordinates are revised with the
objective of improving the quality of the data." The date of the last data
update is registered in the database in the columns \code{date_update} and
\code{year_update}. More information available at \url{https://dados.gov.br/dataset?q=CNES}.
These data use Geodetic reference system "SIRGAS2000" and CRS(4674).
}
\examples{
\dontrun{ if (interactive()) {
# Read all health facilities of the whole country
h <- read_health_facilities()
}}
}
