#' Download spatial data of municipal seats (sede dos municipios) in Brazil
#'
#' @description
#' This function reads the official data on the municipal seats (sede dos municipios)
#' of Brazil. The data brings the geographical coordinates (lat lon) of municipal
#' seats for various years between 1872 and 2010. Original data were generated by
#' Brazilian Institute of Geography and Statistics (IBGE).
#'
#' @param year A year number in YYYY format. Defaults to `2010`
#' @param showProgress Logical. Defaults to `TRUE` display progress bar
#'
#' @return An `"sf" "data.frame"` object
#'
#' @export
#' @examples \dontrun{ if (interactive()) {
#' # Read municipal seats in an specific year
#' m <- read_municipal_seat(year = 1991)
#' }}
read_municipal_seat <- function(year=2010, showProgress=TRUE){

  # Get metadata with data url addresses
  temp_meta <- select_metadata(geography="municipal_seat", year=year, simplified=F)

  # list paths of files to download
  file_url <- as.character(temp_meta$download_path)

  # download files
  temp_sf <- download_gpkg(file_url, progress_bar = showProgress)
  return(temp_sf)
}
