
R : Copyright 2002, The R Development Core Team
Version 1.6.1 Patched (2002-11-06)

R is free software and comes with ABSOLUTELY NO WARRANTY.
You are welcome to redistribute it under certain conditions.
Type `license()' or `licence()' for distribution details.

R is a collaborative project with many contributors.
Type `contributors()' for more information.

Type `demo()' for some demos, `help()' for on-line help, or
`help.start()' for a HTML browser interface to help.
Type `q()' to quit R.


------------------------------------------------
geoR - functions for geostatistical data analysis
geoR version 1.3-7 is now loaded
------------------------------------------------

[Previously saved workspace restored]

> invisible(options(echo = TRUE))
> require(geoR)
[1] TRUE
> options(digits = 3, width = 80)
> set.seed(50)
> ##
> ## Tests for coincident locations
> ##    functions:  krige.bayes, krige.conv and ksline  
> ##
> ## Simulating some data
> ##
> ap <- grf(20, cov.pars=c(3, .25), mess=F)
Loading required package: mva 
> ap$coords <- round(ap$coords, dig=3)
> ## defining prediction locations with 2 points coinciding with data locations
> loci <- matrix(0, ncol=2, nrow=6)
> loci[1,] <- c(.2,.3)
> loci[2,] <- ap$coords[10,]
> loci[3,] <- c(.5,.5)
> loci[4,] <- c(.5,.8)
> loci[5,] <- ap$coords[15,]
> loci[6,] <- c(.7,.9)
> ##
> coinc.data <- round(ap$data[c(10, 15)], dig=4) 
> ## just checking
> ap1 <- loccoords(ap$coords, loci)
> if(sum(ap1==0) !=2)
+   stop("problems with example, more or less than 2 coincident points")
> ##
> ## testing krige.conv
> ##
> out.kc <- output.control(mes=F)
> ##
> ##
> cat("===================================================\n")
===================================================
> cat("TESTING KRIGE.CONV\n")
TESTING KRIGE.CONV
> kc <- krige.conv(ap, loc=loci, krige=krige.control(cov.pars=c(1,.25)), output=out.kc)
> lapply(kc[1:2], round, dig=4)
$predict
[1] -0.0092  0.1829 -1.3880 -1.3926 -1.0547 -1.7107

$krige.var
[1] 0.647 0.000 0.542 0.446 0.000 0.334

> kc.pred <- round(kc$pred[c(2,5)], dig=4)
> kc.var <- round(kc$krige.var[c(2,5)], dig=4)
> ##
> {
+   if(any((kc.pred-coinc.data) !=0)){
+     cat("WARNING: predictions DO NOT coincide with data\n")
+   }
+   else{
+     cat("predictions coincide with data, ok\n")
+   }
+ }
predictions coincide with data, ok
> {
+   if(any(kc.var != 0)){
+     cat("WARNING: kriging variance NOT equals to zero\n")
+   }
+   else{
+     cat("kriging variance equals zero, ok\n")
+   }
+ }
kriging variance equals zero, ok
> cat("===================================================\n")
===================================================
> ##
> ## testing krige.bayes
> ##
> cat("\n")

> cat("\n")

> cat("===================================================\n")
===================================================
> cat("TESTING KRIGE.BAYES\n")
TESTING KRIGE.BAYES
> cat("\n")

> cat("----------------------\n")
----------------------
> cat("Testing with fixed phi\n")
Testing with fixed phi
> cat("----------------------\n")
----------------------
> kb1 <- krige.bayes(ap, loc=loci, prior=prior.control(
+                                    sigmasq.prior="fixed", sigmasq=1,
+                                    phi.prior="fixed", phi=10/3),
+                    output=output.control(mess=F, signal=F))
> kb1$post
$beta
$beta$distribution
[1] "normal"

$beta$pars
$beta$pars$mean
[1] 0.0493

$beta$pars$var
      [,1]
[1,] 0.818



$sigmasq
$sigmasq$status
[1] "fixed"

$sigmasq$fixed.value
[1] 1


$phi
$phi$status
[1] "fixed"

$phi$fixed.value
[1] 3.33


$tausq.rel
$tausq.rel$status
[1] "fixed"

$tausq.rel$fixed.value
[1] 0


attr(,"class")
[1] "posterior.krige.bayes" "variomodel"           
> kb1$pred$mean
[1]  0.0282  0.1829 -1.4811 -1.4508 -1.0547 -1.7538
> kb1$pred$var
[1] 0.0571 0.0000 0.0460 0.0358 0.0000 0.0259
> kb1.pred <- round(kb1$pred$mean[c(2,5)], dig=4)
> kb1.var <- round(kb1$pred$variance[c(2,5)], dig=4)
> ##
> {
+   if(any((kb1.pred-coinc.data) !=0)){
+     cat("WARNING: predictions DO NOT coincide with data\n")}
+   else{cat("predictions coincide with data, ok\n")}
+ }
predictions coincide with data, ok
> {
+   if(any(kb1.var != 0)){
+     cat("WARNING: kriging variance NOT equals to zero\n")}
+   else{cat("kriging variance equals zero, ok\n")}
+ }
kriging variance equals zero, ok
> cat("\n")

> cat("-------------------------\n")
-------------------------
> cat("Testing with variable phi\n")
Testing with variable phi
> cat("-------------------------\n")
-------------------------
> kb2 <- krige.bayes(ap, loc=loci, prior=prior.control(phi.disc=seq(0,2,l=21)),output=output.control(mess=F, n.pred=10))
> ##
> kb2.mom <- round(kb2$pred$mean[c(2,5)], dig=4)
> kb2.mom.var <- round(kb2$pred$variance[c(2,5)], dig=4)
> kb2.sim <- round(kb2$pred$simula[c(2,5),], dig=4)
> kb2.mea <- round(kb2$pred$mean.sim[c(2,5)], dig=4)
> kb2.var <- round(kb2$pred$variance.sim[c(2,5)], dig=4)
> ##
> kb2.mom
[1]  0.183 -1.055
> kb2.mom.var
[1] 0 0
> kb2.sim
       [,1]   [,2]   [,3]   [,4]   [,5]   [,6]   [,7]   [,8]   [,9]  [,10]
[1,]  0.183  0.183  0.183  0.183  0.183  0.183  0.183  0.183  0.183  0.183
[2,] -1.055 -1.055 -1.055 -1.055 -1.055 -1.055 -1.055 -1.055 -1.055 -1.055
> kb2.mea
[1]  0.183 -1.055
> kb2.var
[1] 0 0
> {
+   if(any((kb2.mom-coinc.data) !=0)){
+     cat("WARNING: moments DO NOT coincide with data\n")}
+   else{cat("moments coincide with data, ok\n")}
+ }
moments coincide with data, ok
> {
+   if(any(kb2.mom.var > 0)){
+     cat("WARNING: moments variance DO NOT coincide with data\n")}
+   else{cat("moments variance equals zero, ok\n")}
+ }
moments variance equals zero, ok
> {
+   if(any((kb2.sim-coinc.data) !=0)){
+     cat("WARNING: simulations DO NOT coincide with data\n")}
+   else{cat("simulations coincide with data, ok\n")}
+ }
simulations coincide with data, ok
> {
+   if(any((kb2.mea-coinc.data) !=0)){
+     cat("WARNING: means DO NOT coincide with data\n")}
+   else{cat("means coincide with data, ok\n")}
+ }
means coincide with data, ok
> {
+   if(any(kb2.var > 0)){
+     cat("WARNING: variances DO NOT coincide with data\n")}
+   else{cat("variances equal zero, ok\n")}
+ }
variances equal zero, ok
> cat("===================================================\n")
===================================================
> proc.time()
[1] 2.28 0.13 2.38 0.00 0.00
> 
