% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchdata.r
\name{namedata}
\alias{namedata}
\title{names a data set so that it can be restored by that name later on}
\usage{
namedata(name, original = NULL, clear = FALSE)
}
\arguments{
\item{name}{a string giving the desired name for the dataset}

\item{original}{a string giving the current name of the dataset or NULL to set the name for the currently-loaded dataset (default: NULL)}

\item{clear}{if TRUE, overwrite current dataset at that name, if FALSE, stop if the dataset already exists (default: FALSE).}
}
\value{
returns NULL invisibly
}
\description{
names a data set so that it can be restored by that name later on
}
\examples{
use(cars, clear=TRUE)
namedata("cars", clear=TRUE)
library(plm)
data(Produc)
use(Produc, clear=TRUE)
namedata("product", clear=TRUE)
listdata()
namedata("cars_new_name", original="cars", clear=TRUE)
listdata()
}
