% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_finder_nleqslv.R
\name{zero_finder_nleqslv}
\alias{zero_finder_nleqslv}
\title{Zero finder}
\usage{
zero_finder_nleqslv(
  afun,
  veclength,
  tol = 0.4,
  x.start.vals = NULL,
  upper.lim = Inf
)
}
\arguments{
\item{afun}{The function to find zeros}

\item{veclength}{The dimension of the system of equations}

\item{tol}{The range within which to set start values for the function to use to find zeros}

\item{x.start.vals}{Optional user defined start values}

\item{upper.lim}{to be used if there is to be an upper limit to the solution}
}
\value{
Predicted zeros of the given equation
}
\description{
Finds zeros of multinomial functions using the nleqslv package
}
\examples{
afun <- function(x) {
	y <- numeric(2)
	y[1] <- x[1]^2 + x[2]^2 - 1
	y[2] <- exp(x[1]-1) + x[2]^3 - 1.1
	y
}

zero_finder_nleqslv(afun, veclength = 2)

}
