% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/43_fun_reg.pathmox.R
\name{reg.pathmox}
\alias{reg.pathmox}
\title{PATHMOX-REG: Segmentation Trees in 
 linaer and LAD regression model}
\usage{
reg.pathmox(formula, SVAR, signif, deep, method, size, data = NULL, ...)
}
\arguments{
\item{formula}{An object of class \code{"formula"}.}

\item{SVAR}{A data frame of factors contaning the segmentation variables.}

\item{signif}{A numeric value indicating the significance threshold of the
F-statistic. Must be a decimal number between 0 and 1.}

\item{deep}{An integer indicating the depth level of the tree. Must be an
integer greater than 1.}

\item{method}{A string indicating the criterion used to calculate the
the test can be equal to \code{"lm"} or \code{"lad"}
node.}

\item{size}{A numeric value indicating the minimum size of elements inside a
node.}

\item{data}{an optional data frame.}

\item{\dots}{Further arguments passed on to \code{\link{reg.pathmox}}.}
}
\value{
An object of class \code{"xtree.reg"}. Basically a list with the
following results:

\item{MOX}{Data frame with the results of the segmentation tree}

\item{root}{element of contaning in the root node}

\item{terminal}{element of contaning in the terminal nodes}

\item{nodes}{element of contaning in all nodes terminal and intermediate}

\item{candidates}{List of data frames containing the candidate 
splits of each node partition}

\item{Fg.r}{Data frame containing the results of the F-global test 
for each node partition}

\item{Fc.r}{A list of Data frames containing the results of the F-coefficients test 
for each node partition}

\item{model}{Information about the internal paramenters}
}
\description{
The function \code{reg.pathmox} calculates a binary segmentation tree in the context 
of linear regression following the PATHMOX algorithm. This function also generalizes the Pathmox 
algorithm introduced by Sanchez in 2009 to the context of linear and LAD regression.
}
\details{
The argument \code{formula} is an object of class \code{"formula"} (or one that can be coerced to that class): 
a symbolic description of the model to be fitted. 


The argument \code{SVAR} must be a data frame containing segmentation
variables as factors. The number of rows in
\code{SVAR} must be the same as the number of rows in the data 
 
The argument \code{signif} represent the p-value level takes as reference  
to stop the tree partitions. 

The argument \code{deep} represent the p-value level takes as reference  
to stop the tree partitions. 

The argument \code{method} is a string contaning the criterion used to calculate the   
the test; if \code{method="lm"} the classic least square approach is used to perform the test; 
if \code{method="lad"} the lad (least absolute deviation) is used.

The argument \code{size} has defined as a decimal value (i.e. proportion
of elements inside a node).
}
\examples{

 \dontrun{
##example of LM in alumni satisfaction
 
data(fibtelereg)

#identify the segmentation variables  
segvar = fibtelereg[,2:11]

#select the variables
data.fib = fibtelereg[,12:18]          

#re-ordering those segmentation variables with ordinal scale
segvar$Age     = factor(segvar$Age, ordered=T)
segvar$Salary   = factor(segvar$Salary, 
	levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade, 
	levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade, 
	levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

#regression PATHMOX
fib.reg.pathmox = reg.pathmox(Satisfact~.,data=data.fib,segvar,
	signif=0.05,deep=2,method="lm",size=0.15)

}
 
data(fibtelereg)

#identify the segmentation variables  
segvar= fibtelereg[1:50,3:4]

#select the variables
data.fib=fibtelereg[1:50,12:18]          

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
	signif=0.05,deep=1,method="lm",size=0.15)

}
\references{
Aluja, T. Lamberti, G. Sanchez, G. (2013). Modeling with heterogeneity. 
Meetings of Italian Statistical Society, Advances in Latent Variables - Methods, 
Models and Applications. Brescia.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.

Sanchez, G. (2009) \emph{PATHMOX Approach: Segmentation Trees in
Partial Least Squares Path Modeling.} PhD Dissertation.
}
\author{
Giuseppe Lamberti
}
