% Generated by roxygen2 (4.0.2): do not edit by hand
\name{reg.treemodel}
\alias{reg.treemodel}
\title{Regression results of terminal nodes from the Pathmox Segmentation Trees}
\usage{
reg.treemodel(xtree.reg, terminal = TRUE, intercept = FALSE, ...)
}
\arguments{
\item{xtree.reg}{An object of class \code{"xtree.reg"} returned by
\code{\link{reg.pathmox}}.}

\item{terminal}{is string, if equal to \code{TRUE}, just the terminal nodes are considered
for the output reults. when it is equal to \code{FALSE},the regression results are generated
for all nodes of the tree}

\item{intercept}{if equal to \code{TRUE} also the intercept is considered in the estimation}

\item{\dots}{Further arguments passed on to \code{\link{reg.treemodel}}.}
}
\value{
An object of class \code{"regtreemodel"}. Basically a list with the
following results:

\item{inner}{Matrix of the inner relationship between latent variables of the PLS-PM model}

\item{method}{A string containing the used method ("lm" or "lad"}

\item{coefficients}{Matrix coefficients for each terminal node}

\item{d.estandard}{Matrix of estandard deviation of coefficients for each terminal node}

\item{pval.coef}{Matrix of p-value significance for each terminal node}

\item{r2}{Matrix of r-squared coefficients for each terminal node}

\item{test.dif}{results of test comparison}
}
\description{
Calculates basic regression results for the terminal nodes of Pathmox Segmentation Trees: liner regression and LAD
trees
}
\details{
The argument \code{xtree.reg} is an object of class \code{"xtree.reg"} returned by
\code{\link{reg.pathmox}}.
}
\examples{
\dontrun{
#example of LM in alumni satisfaction

data(fibtelereg)

segvar= datafib.reg[,2:11]

data.fib=datafib.reg[,12:18]

segvar$Age 		= factor(segvar$Age, ordered=T)
segvar$Salary 	= factor(segvar$Salary,
		levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade,
		levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade,
		levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
			signif=0.05,deep=2,method="lm",size=0.15,df="mod1")

#terminal nodes comparison
fib.node.comp=reg.treemodel(fib.reg.pathmox)

}
}
\author{
Giuseppe Lamberti
}
\references{
Sanchez, G. (2009) \emph{PATHMOX Approach: Segmentation Trees in
Partial Least Squares Path Modeling.} PhD Dissertation.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\seealso{
\code{\link{pls.pathmox}},\code{\link{plot.xtree.pls}}
}

