% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyrics.R
\name{get_lyrics_id}
\alias{get_lyrics_id}
\title{Retrieve lyrics associated with a Genius song ID}
\usage{
get_lyrics_id(song_id, access_token = genius_token())
}
\arguments{
\item{song_id}{ID of the song (\code{song_id} within an object returned by
\code{\link{search_song}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\description{
Get lyrics from Genius' lyric pages using an associated song ID.
}
\examples{
\dontrun{
get_lyrics_id(song_id = 3214267)
}
}
\seealso{
See \code{\link{get_lyrics_url}} to search lyrics using a song
URL, \code{\link{get_lyrics_search}} to search using artist name and song
title

Other lyrics: 
\code{\link{get_lyrics_search}()},
\code{\link{get_lyrics_url}()}
}
\concept{lyrics}
