% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GcRsqYXc.R
\name{GcRsqYXc}
\alias{GcRsqYXc}
\title{Nonlinear Granger causality between two time series workhorse function.(local 
constant version)}
\usage{
GcRsqYXc(y, x, px = 4, py = 4, pwanted = 4, ctrl = 0)
}
\arguments{
\item{y}{{The data vector y for the Left side or dependent or first variable}}

\item{x}{{The data vector x for the right side or explanatory or second variable}}

\item{px}{{number of lags of x in the data}}

\item{py}{{number of lags of y in the data. px=4 for quarterly data}}

\item{pwanted}{{number of lags of both x and y wanted for Granger causal analysis}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths
default=0 means no control variables are present}}
}
\value{
This function returns a set of 2 numbers measuring nonlinear Granger-causality 
for time series. out[1]=Rsqyyx, out[2]=Rsqyy.
}
\description{
Function input is y=LHS=First time series and x=RHS=Second time series.
Kernel regression np package options regtype="lc" for local constant, 
and bwmethod="cv.ls" for least squares-based bandwidth selection are fixed.
Denote Rsq=Rsquare=R^2 in nonlinear kernel regression.
GcRsqYXc(.) computes the following two R^2 values.
out[1]=Rsqyyx = R^2 when we regress y on own lags of y and x.
out[2]=Rsqyy = R^2 when we regress y on own lags of y alone.
}
\note{
If data are annual or if no quarterly-type structure is present,
use this function with pwanted=px=py.  For example, the egg or chicken
data from lmtest package, Thurman W.N. and Fisher M.E. (1988)
}
\examples{


\dontrun{
library(Ecdat);options(np.messages=FALSE);attach(data.frame(MoneyUS))
GcRsqYXc(y,m) 
}



}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \url{https://doi.org/gffn86}

Vinod, H. D. 'New exogeneity tests and causal paths,'
 Chapter 2 in 'Handbook of Statistics: Conceptual Econometrics 
Using R', Vol.32, co-editors: H. D. Vinod and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2019, pp. 33-64.

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: 
\url{https://www.ssrn.com/abstract=2982128}

Zheng, S., Shi, N.-Z., Zhang, Z., 2012. 
Generalized measures of correlation for
asymmetry, nonlinearity, and beyond. Journal of the American Statistical
Association 107, 1239-1252.
}
\seealso{
\code{\link{GcRsqX12c}}

\code{\link{kern_ctrl}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
