% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootGcRsq.R
\name{bootGcRsq}
\alias{bootGcRsq}
\title{Compute vector of n999 nonlinear Granger causality paths}
\usage{
bootGcRsq(x1, x2, px2 = 4, px1 = 4, pwanted = 4, ctrl = 0, n999 = 9)
}
\arguments{
\item{x1}{{The data vector x1}}

\item{x2}{{The data vector x2}}

\item{px2}{{number of lags of x2 in the data, default px2=4}}

\item{px1}{{number of lags of x1 in the data default px1=4}}

\item{pwanted}{{number of lags of both x2 and x1 wanted for 
Granger causal analysis, default =4}}

\item{ctrl}{{data matrix having control variable(s) if any}}

\item{n999}{{Number of bootstrap replications (default=9)}}
}
\value{
out {is  n999 X 3 matrix for 3 outputs of GcauseX12 resampled}
}
\description{
Maximum entropy bootstrap (meboot) package is used for statistical inference
The bootstrap output can be analyzed to estimate an approximate confidence
interval on sample-based direction of the causal path.
Kernel regression np package options regtype="ll" for local linear, 
and bwmethod="cv.aic" for AIC-based bandwidth selection are fixed.
}
\note{
This computation is computer intensive and generally very slow. 
  It may be better to use this function
  it at a later stage in the investigation, after a preliminary 
  causal determination is already made. The 3 outputs of GauseX12 are
  two Rsquares and the difference between after subtracting the second
  from the first.  Col. 1 has RsqX1onX2
  Col.2 has RsqX2onX1, and Col.3 has dif=(RsqX1onX2 -RsqX2onX1)
  If both col.1 and Col.2 are positive, we have bi-directional 
  feedback causal path x1 <--> x2. If RsqX1onX2>0 and RsqX2onX1<0
  then causal path x2 --> x1.  If RsqX1onX2<0 and RsqX2onX1>0
  then causal path x1 --> x2 holds.
}
\examples{
\dontrun{
library(Ecdat);options(np.messages=FALSE);attach(data.frame(MoneyUS))
bootGcRsq(y,m,n999=9) 
}
\dontrun{
library(lmtest); data(ChickEgg);attach(data.frame(ChickEgg))
b2=bootGcLC(x1=chicken,x2=egg,pwanted=3,px1=3,px2=3,n999=99)
}
}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with 
 Applications in Development Economics' in Communications in 
 Statistics -Simulation and Computation, 2015, 
 \url{https://doi.org/gffn86}

Zheng, S., Shi, N.-Z., and Zhang, Z. (2012). Generalized measures 
 of correlation for asymmetry, nonlinearity, and beyond. 
 Journal of the American Statistical Association, vol. 107, pp. 1239-1252.

Vinod, H. D. and Lopez-de-Lacalle, J. (2009). 'Maximum entropy bootstrap
 for time series: The meboot R package.' Journal of Statistical Software,
 Vol. 29(5), pp. 1-19.

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: \url{https://www.ssrn.com/abstract=2982128}
}
\seealso{
See Also \code{\link{GcRsqX12}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{maximum entropy bootstrap}
