% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtor.R
\name{filter_plink.pedmap}
\alias{filter_plink.pedmap}
\title{filter_plink.pedmap}
\usage{
filter_plink.pedmap(x,
                    mode = c("POS", "type", "both"),
                    Chr = Chr, start = start, end = end,
                    gff = gff, type = type, cusTyp = cusTyp)
}
\arguments{
\item{x}{a list stored the p.link information}

\item{mode}{filtration mode, one of c("POS", "type", "both")}

\item{Chr}{the chromosome name, need if mode set as POS or both}

\item{start, end}{numeric, the range of filtration, and the start should smaller than end}

\item{gff}{the imported gff object}

\item{type}{should be in \code{unique(gff$type)}, usually as "CDS", "genome".}

\item{cusTyp}{if \code{type} set as custom, then \code{cusTyp} is needed}
}
\value{
list, similar with \code{x}, but filtered
}
\description{
used for filtration of p.link
}
\examples{
\donttest{
   pedfile <- system.file("extdata",
                          "snp3kvars-CHR8-25947258-25951166-plink.ped",
                          package = "geneHapR")
   mapfile <- system.file("extdata",
                          "snp3kvars-CHR8-25947258-25951166-plink.map",
                          package = "geneHapR")
   p.link <- import_plink.pedmap(pedfile = pedfile, mapfile = mapfile,
                                 sep_map = "\t", sep_ped = "\t")
   p.link <- filter_plink.pedmap(p.link, mode = "POS",
                                 Chr = "chr08", start = 25948004,
                                 end = 25949944)
   hapResult <- plink.pedmap2hap(p.link, hapPrefix = "H",
                                 hyb_remove = TRUE,
                                 na.drop = TRUE)
}
}
