/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.Likelihood;

public class AttritionLikelihoodPlus
implements Likelihood {
    private int[] vec0;
    private int[] vec1;
    private double[][] probs;
    private int n;

    public AttritionLikelihoodPlus(int[] racevec, int[] finishvec) {
        this.vec0 = racevec;
        this.vec1 = finishvec;
        this.n = this.vec0.length;
        int currentrace = -1;
        this.probs = new double[this.vec0[this.n - 1] + 1][];
        for (int i0 = this.n - 1; i0 >= 0; --i0) {
            int i = this.vec0[i0];
            if (i == currentrace) continue;
            this.probs[i] = new double[this.vec1[i0]];
            for (int j = 0; j < this.probs[i].length; ++j) {
                this.probs[i][j] = 0.0;
            }
            currentrace = i;
        }
    }

    public double compute(double[][] args) {
        int i;
        int i0;
        for (i0 = 0; i0 < this.n; ++i0) {
            i = this.vec0[i0];
            int j = this.vec1[i0];
            this.probs[i][j - 1] = j == 1 ? Math.exp(-(args[0][i0] + (double)(j - 1) * args[1][i0]) * args[2][i0]) : this.probs[i][j - 2] + Math.exp(-(args[0][i0] + (double)(j - 1) * args[1][i0]) * args[2][i0]);
        }
        for (i0 = 0; i0 < this.vec0.length; ++i0) {
            i = this.vec0[i0];
            this.probs[i][this.vec1[i0] - 1] = Math.exp(-(args[0][i0] + (double)(this.vec1[i0] - 1) * args[1][i0]) * args[2][i0]) / this.probs[i][this.vec1[i0] - 1];
        }
        double out = 0.0;
        for (int i02 = 0; i02 < this.probs.length; ++i02) {
            for (int j0 = 0; j0 < this.probs[i02].length; ++j0) {
                out += Math.log(this.probs[i02][j0]);
            }
        }
        return out;
    }

    public static void main(String[] args) {
    }
}

