/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.model;

import com.jgoodies.binding.beans.Observable;
import com.jgoodies.binding.list.ObservableList;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.drugis.common.beans.ObserverManager;
import org.drugis.mtc.data.DataType;
import org.drugis.mtc.data.StudyData;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Treatment;

public class Study
extends StudyData
implements Observable,
Comparable<Study> {
    public static final String PROPERTY_ID = "id";
    @XmlTransient
    ObserverManager d_obsManager = new ObserverManager(this);

    public Study() {
    }

    public Study(String id) {
        this.setId(id);
    }

    @Override
    public void setId(String newValue) {
        String oldValue = this.getId();
        super.setId(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_ID, oldValue, newValue);
    }

    public ObservableList<Measurement> getMeasurements() {
        return (ObservableList)super.getMeasurementList();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.d_obsManager.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.d_obsManager.addPropertyChangeListener(listener);
    }

    @Override
    public String toString() {
        return "Study[" + this.getId() + "]";
    }

    public Study restrictMeasurements(DataType type) {
        Study s = new Study();
        s.setId(this.getId());
        for (Measurement m : this.getMeasurements()) {
            s.getMeasurements().add(m.restrict(type));
        }
        return s;
    }

    public boolean containsTreatment(final Treatment t) {
        return CollectionUtils.exists(this.getMeasurements(), new Predicate<Measurement>(){

            @Override
            public boolean evaluate(Measurement m) {
                return m.getTreatment().equals(t);
            }
        });
    }

    public Set<Treatment> getTreatments() {
        HashSet<Treatment> treatments = new HashSet<Treatment>();
        for (Measurement m : this.getMeasurements()) {
            treatments.add(m.getTreatment());
        }
        return treatments;
    }

    @Override
    public int compareTo(Study s) {
        return this.getId().compareTo(s.getId());
    }
}

