% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.lin}
\alias{gelnet.lin}
\title{GELnet for linear regression}
\usage{
gelnet.lin(X, y, l1, l2, a = rep(1, n), d = rep(1, p), P = diag(p),
  m = rep(0, p), max.iter = 100, eps = 1e-05, w.init = rep(0, p),
  b.init = sum(a * y)/sum(a), fix.bias = FALSE, silent = FALSE)
}
\arguments{
\item{X}{n-by-p matrix of n samples in p dimensions}

\item{y}{n-by-1 vector of response values}

\item{l1}{coefficient for the L1-norm penalty}

\item{l2}{coefficient for the L2-norm penalty}

\item{a}{n-by-1 vector of sample weights}

\item{d}{p-by-1 vector of feature weights}

\item{P}{p-by-p feature association penalty matrix}

\item{m}{p-by-1 vector of translation coefficients}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{w.init}{initial parameter estimate for the weights}

\item{b.init}{initial parameter estimate for the bias term}

\item{fix.bias}{set to TRUE to prevent the bias term from being updated (default: FALSE)}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}
}
\value{
A list with two elements:
\describe{
  \item{w}{p-by-1 vector of p model weights}
  \item{b}{scalar, bias term for the linear model}
}
}
\description{
Constructs a GELnet model for linear regression using coordinate descent.
}
\details{
The method operates through cyclical coordinate descent.
The optimization is terminated after the desired tolerance is achieved, or after a maximum number of iterations.
}

