\name{load.rjmcmc}
\alias{load.rjmcmc}
\title{posterior samples from single or multiple MCMC runs}
\description{generating a pooled and thinned sample of posterior estimates from rjmcmc}
\usage{

	\method{load}{rjmcmc}(x, phy = NULL, burnin = NULL, thin = NULL, \dots)
}

\arguments{
  \item{x}{a vector of directory names (character strings) in which samples generated by \pkg{geiger} are found}
  \item{phy}{a phylogenetic tree of class 'phylo' for which to compile results; if NULL, the tree stored within each generated \code{rda} file is used}
  \item{burnin}{the proportion of each chain to be removed as burnin}
  \item{thin}{an integer specifying the thinning interval for chains}
  \item{...}{arguments to be passed to other functions (has no effect in the present context)}
}

\details{
This function provides a means to compile results from at least a single MCMC run, and is especially useful in pooling of multiple independent runs. In cases where MCMC chains were sampled
using a set of (different) trees, the argument \code{phy} can be used to summarize compiled results against a single summary tree. Branchwise samples are stored with unique edge identifiers 
(character strings) that are more reliable than the use of numeric node-identifiers (see \code{\link[digest]{digest}} for the function used to generate these unique edge labels). 

If it is desired to run analyses for the same trait data across a set of trees (see \bold{Examples}), it is strongly recommended that the set of trees be sent to \code{rjmcmc.bm} as a \code{multiPhylo} 
object (see \code{\link[ape]{read.tree}}).
}  

\value{
an object of class \code{rjmcmc} or \code{rjmcmcmc}}

\author{JM Eastman}

\seealso{\code{\link[geiger]{rjmcmc.bm}}}

\examples{
\donttest{
sal=get(data(caudata))
a<-sim<-sal$phy
bl=c(386,387,388,183,184,185,186)
mod=match(bl, sim$edge[,2])
sim$edge.length[mod]=sim$edge.length[mod]*64
dat=rTraitCont(sim)
while(1){
	b=a
	b$tip.label[183:186]=sample(b$tip.label[183:186])
	if(!all(a$tip.label==b$tip.label)) break()
}

trees=list(a=a,b=b, c=ladderize(a, right=TRUE), d=ladderize(a, right=FALSE))
class(trees)="multiPhylo"
rjmcmc.bm(trees, dat, ngen=1e3, type="rbm")

res=load(paste("relaxedBM", names(trees), sep="."), phy=trees$d, burnin=0.25)
plot(res, par="shifts", show.tip=FALSE, edge.width=2.5)
}
}
\keyword{data}
\keyword{manip}


