% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess.R
\name{loess_optdiscnum}
\alias{loess_optdiscnum}
\title{determine optimal spatial data discretization for individual variables}
\usage{
loess_optdiscnum(qvec, discnumvec, increase_rate = 0.05)
}
\arguments{
\item{qvec}{A numeric vector of q statistics.}

\item{discnumvec}{A numeric vector of break numbers corresponding to \code{qvec}.}

\item{increase_rate}{(optional) The critical increase rate of the number of discretization.
Default is \verb{5\%}.}
}
\value{
A numeric vector about optimal number of spatial data discretization and the critical
increase rate of the number of discretization.
}
\description{
Function for determining optimal spatial data discretization for individual variables
based on locally estimated scatterplot smoothing (LOESS) model.
}
\note{
When \code{increase_rate} is not satisfied by the calculation, \code{increase_rate*0.1} is used first.
At this time, if \code{increase_rate*0.1} is not satisfied again, the discrete number corresponding
to the highest Q-statistic is selected as a return.

Note that \code{gdverse} sorts \code{discnumvec} from smallest to largest and keeps \code{qvec} in
one-to-one correspondence with \code{discnumvec}.
}
\examples{
data('sim')
3:10 \%>\%
  purrr::map_dbl(\(.k) st_unidisc(sim$xa,.k) \%>\%
               factor_detector(sim$y,.) \%>\%
               {.[[1]]}) \%>\%
 loess_optdiscnum(3:10)

}
\references{
Yongze Song & Peng Wu (2021) An interactive detector for spatial associations,
International Journal of Geographical Information Science, 35:8, 1676-1701,
DOI:10.1080/13658816.2021.1882680
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
