% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{renameDataset}
\alias{renameDataset}
\title{Rename a dataset}
\usage{
renameDataset(new_filename, old_filename, format = "")
}
\arguments{
\item{new_filename}{New name for the dataset.}

\item{old_filename}{Old name for the dataset (should not be open in a
\code{GDALRaster} object).}

\item{format}{Raster format short name (e.g., "GTiff"). If set to empty
string \code{""} (the default), will attempt to guess the raster format from
\code{old_filename}.}
}
\value{
Logical \code{TRUE} if no error or \code{FALSE} on failure.
}
\description{
\code{renameDataset()} renames a dataset in a format-specific way (e.g.,
rename associated files as appropriate). This could include moving the
dataset to a new directory or even a new filesystem.
The dataset should not be open in any existing \code{GDALRaster} objects
when \code{renameDataset()} is called. Wrapper for \code{GDALRenameDataset()} in the
GDAL API.
}
\note{
If \code{format} is set to an empty string \code{""} (the default) then the function
will try to identify the driver from \code{old_filename}. This is done
internally in GDAL by invoking the \code{Identify} method of each registered
\code{GDALDriver} in turn. The first driver that successful identifies the file
name will be returned. An error is raised if a format cannot be determined
from the passed file name.
}
\examples{
b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
b5_tmp <- paste0(tempdir(), "/", "b5_tmp.tif")
file.copy(b5_file,  b5_tmp)

ds <- new(GDALRaster, b5_tmp)
ds$buildOverviews("BILINEAR", levels = c(2, 4, 8), bands = c(1))
ds$getFileList()
ds$close()
b5_tmp2 <- paste0(tempdir(), "/", "b5_tmp_renamed.tif")
renameDataset(b5_tmp2, b5_tmp)
ds <- new(GDALRaster, b5_tmp2)
ds$getFileList()
ds$close()

deleteDataset(b5_tmp2)
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=create]{create()}}, \code{\link[=createCopy]{createCopy()}},
\code{\link[=deleteDataset]{deleteDataset()}}, \code{\link[=copyDatasetFiles]{copyDatasetFiles()}}
}
